package gov.va.med.ccht.ui.common.model
{
	import gov.va.med.fw.model.TermType;
	
	import mx.collections.ArrayCollection;

	[Bindable]
	[RemoteClass(alias="gov.va.med.ccht.ui.model.UserPrincipalForm")]
	public class UserPrincipal
	{
		public var permissions:ArrayCollection = null;
		public var userName:String = null;
		public var givenName:String = null;
		public var middleName:String = null;
		public var familyName:String = null;
		public var email:String = null;
		public var visn:TermType= null;
		public var facility:TermType = null;
		public var secondaryFacility:TermType = null;
		public var vendor:TermType = null;
		
		//User Preferences
		public var maxOpenWindows:int = 0;
		public var appWindowWidth:int = 0;
		public var appWindowHeight:int = 0;
		public var multipleWindows:Boolean = true;
		
		public function UserPrincipal()
		{
		}
		//Verify that user is authorized
		public function isAuthorized(permission:String) : Boolean {
            if (permissions != null && permissions.contains(permission)) {
				return true;
			}
			return false;
		}

		//Verify that user is authorized for one of these permissions
		public function isAuthorizedAny(permissions:ArrayCollection) : Boolean {
            if (this.permissions != null && permissions != null && permissions.length > 0) {
				 for (var i:int = 0; i< permissions.length; i++) {
					if (this.permissions.contains(permissions.getItemAt(i))) {
						return true;
					}
				}
			}
			return false;
		}
	}
}