package gov.va.med.ccht.ui.common.model
{
	import gov.va.med.ccht.ui.common.model.FormattedDate;
	import gov.va.med.fw.model.TermType;
	
	import mx.collections.ArrayCollection;
	
	[Bindable]
	[RemoteClass(alias="gov.va.med.ccht.ui.model.ReportScheduleForm")]
		
	public class ReportSchedule {
       public var runFrequency:TermType;
	   public var scheduleType:TermType;
	   public var dayOfMonth:TermType;
	   public var weekOfMonth:TermType;
	   public var dayOfWeek:TermType;
	   public var dayOfQuarter:TermType;
	   public var month:TermType;
	   public var numericDayOfMonth:Number;
	   public var dateToGenerate:FormattedDate = new FormattedDate();
	   public var hour:Number;
	   public var minute:Number;
	   public var daysOfWeek:ArrayCollection;
	   public var cronExpression:String
	   public var friendlyDescription:String;
	   public var nextFireTime:FormattedDate;
	   
	   public function get selectedHour():TermType {
		   if (hour) {
			   return TermType.create(hour.toString(),hour.toString());
		   }else {
			   return null;
		   }
	   }
	   public function get selectedMinute():TermType {
		   if (minute) {
			   return TermType.create(minute.toString(),minute.toString());
		   }else {
			   return null;
		   }
	   }	   
	}

}

