package gov.va.med.ccht.ui.common.model
{
	import gov.va.med.ccht.ui.common.utils.TermsCache;
	import gov.va.med.fw.utils.FormatUtils;
	import gov.va.med.fw.model.TermType;
	
	import mx.collections.ArrayCollection;
	
	[Bindable]
	[RemoteClass(alias="gov.va.med.ccht.ui.model.ReportParametersForm")]
		
	public class ReportParameters {	
		public var fromDate:Date;
		public var toDate:Date;
		public var asOfDate:Date;
		public var reportFormat:TermType;
		public var reportSummaryType:TermType;
		public var reportWeek:ReportWeek;
		public var visn:TermType;
		public var facility:TermType;
		public var subTotalType:TermType;
		public var facilityId:String;
		public var reportName:String;
		public var deviceStatuses:ArrayCollection;
		public var allDeviceStatuses:Boolean;
			 		
		/* Scheduled Report from and to fields */
		public var scheduledReportFromType:TermType;
		public var scheduledReportFromSpecificFixedDate:Date;
		public var scheduledReportFromNumUnitsPriorToCurrentDay:Number;
		public var scheduledReportFromUnitPriorToCurrentDay:TermType;
		public var scheduledReportFromFixedDateType:TermType;
		public var scheduledReportFromUsePreviousDatePeriod:Boolean;
		public var scheduledReportFromMultiDayTimeUnitType:TermType;
		
		public var scheduledReportToType:TermType;
		public var scheduledReportToSpecificFixedDate:Date;
		public var scheduledReportToNumUnitsPriorToCurrentDay:Number;
		public var scheduledReportToUnitPriorToCurrentDay:TermType;
		public var scheduledReportToFixedDateType:TermType;
		public var scheduledReportToUsePreviousDatePeriod:Boolean;
		public var scheduledReportToMultiDayTimeUnitType:TermType;
		
		public var scheduledReportDaysToKeepCompletedReports:Number;
				
		private  function filter(srcList:ArrayCollection, selectedList:ArrayCollection):ArrayCollection {
			var filteredList:ArrayCollection =  new ArrayCollection();
			if (selectedList != null && selectedList.length > 0) {
				//for (var srcTerm:TermType in srcList) {
				for (var i : int = 0; i < srcList.length; i++) {
					//for (var selectedTerm:TermType in selectedList) {
					for (var j : int = 0; j < selectedList.length; j++) {
						if (srcList.getItemAt(i).value == selectedList.getItemAt(j).value) {
							filteredList.addItem(srcList.getItemAt(i));
							break;
						}
					}
				}
			}
			return filteredList;
		}
		 
		public function get selectedStatuses():String {
			if (allDeviceStatuses) {
				return "All";
			}else {
				return FormatUtils.formatTermTypeList(deviceStatuses);
			}
		}          
	}
}

