package gov.va.med.ccht.ui.common.model {
import gov.va.med.fw.model.TermType;
import gov.va.med.fw.utils.EqualsBuilder;
import gov.va.med.fw.utils.FormatUtils;

import mx.collections.ArrayCollection;
import mx.formatters.DateFormatter;
import mx.utils.StringUtil;
[Bindable] [RemoteClass(alias="gov.va.med.ccht.model.dmp.DMPStandLibEntry")]
public class DMPStandLibEntry implements IEquals
{
  public var id:Number;
  public var slCategoryTermType:TermType;
  public var slCategoryTableValue:String;
  public var slContentTermType:TermType;
  public var slContentTableValue:String;
  public var slContent:String;
  public var clinicalEvidenceVA:Boolean;
  public var clinicalEvidenceAhrq:Boolean;
  //public var clinicalGuidanceTermType:TermType;
  public var clinicalEvidenceOther:Boolean;
  public var ceOtherText:String;
  public var reasonModTermType:TermType;
  public var rsnModComment:String;
  public var clinicalGuidanceListValue:String;
  
  public function equals(object:Object):Boolean {
	  if (!object) { return false; }
	  if (object == this) { return true; }
	  if (object is DMPStandLibEntry) {
		  var other:DMPStandLibEntry = object as DMPStandLibEntry;				
		  return new EqualsBuilder()
		  			.append(id, other.id)
		  .append(slCategoryTermType, other.slCategoryTermType)
		  .append(slContentTermType, other.slContentTermType)
		  .append(nullToString(slContent), nullToString(other.slContent))
		  .append(clinicalEvidenceVA, other.clinicalEvidenceVA)
		  //.append(clinicalGuidanceTermType, other.clinicalGuidanceTermType)
		  .append(clinicalEvidenceOther,other.clinicalEvidenceAhrq)
		  .append(clinicalEvidenceOther,other.clinicalEvidenceOther)
		  .append(nullToString(ceOtherText),nullToString(other.ceOtherText))
		  .append(reasonModTermType, other.reasonModTermType)
		  .append(nullToString(rsnModComment),nullToString(other.rsnModComment))
		  .equals;					
	  }
	  else {
		  return false;
	  }
	  return false;
  }
  private function nullToString(a:String):String {
	  return a==null ? "" : a;
  }
  public function formatDate( date:Date ) : String {
	  if( date != null ) {
		  var df:DateFormatter = new DateFormatter();
		  df.formatString="MM/DD/YYYY";
		  return df.format(date);
	  }	
	  return null;
  }
}
}
