package gov.va.med.ccht.ui.common.model
{
	import gov.va.med.fw.model.TermType;
	import gov.va.med.fw.utils.EqualsBuilder;
	import gov.va.med.fw.utils.FormatUtils;
	
	import mx.collections.ArrayCollection;
	import mx.formatters.DateFormatter;
	import mx.utils.StringUtil;
	import mx.controls.Alert;
	
	[Bindable] [RemoteClass(alias="gov.va.med.ccht.model.dmp.DMPResponse")]
	public class DMPResponse extends Form implements IEquals{
		
		public var alertLevel:Number=0;
		public var branchId:Number=-1;
		public var eduContent:String="";
		public var vendorInstrContent:String="";
		public var responseContent:String="";
		public var question:DMPQuestion;
		//public var id:Number;
		
		public function DMPResponse()
		{
			super();
		}
		public function equals(object:Object):Boolean {
			if (!object) { return false; }
			if (object == this) { return true; }
			if (object is DMPResponse) {
				var other:DMPResponse = object as DMPResponse;	
				//Alert.show("other alert:"+other.alertLevel);
				//Alert.show("alert:"+alertLevel);
				return new EqualsBuilder()
				.append(nullToString(responseContent), nullToString(other.responseContent))
					.append(nullToString(eduContent), nullToString(other.eduContent))
					.append(nullToString(vendorInstrContent), nullToString(other.vendorInstrContent))
					.append(alertLevel,other.alertLevel)
					.append(branchId,other.branchId)
					.equals;					
			}
			else {
				return false;
			}
			return false;
		}
		private function nullToString(a:String):String {
			return a==null ? "" : a;
		}
	}
}