package gov.va.med.ccht.ui.common.model
{
	import gov.va.med.fw.model.TermType;
	import gov.va.med.fw.utils.EqualsBuilder;
	import gov.va.med.fw.utils.FormatUtils;
	
	import mx.collections.ArrayCollection;
	import mx.formatters.DateFormatter;
	import mx.utils.StringUtil;
	
	[Bindable] [RemoteClass(alias="gov.va.med.ccht.model.dmp.DMPQuestion")]
	public class DMPQuestion implements IEquals{
		
		public var dmp:DMP;
		public var questionContent:String;
		public var frequency:String;
		public var additionalInstructions:String;
		public var questionResponseTermType:TermType;
		public var questionContentTermType:TermType;
		public var id:Number=-1;
		public var markAsDeleted:Boolean;	
		public var questionOrder:String;
		public var contentOrder:Number;
		public var response:DMPResponse;
		public var responses:ArrayCollection;
		public var locked:Boolean;
		public var reviewComments:ArrayCollection;
		
		public function DMPQuestion()
		{
			//super();
		}
		public function equals(object:Object):Boolean {
			if (!object) { return false; }
			if (object == this) { return true; }
			if (object is DMPQuestion) {
				var other:DMPQuestion = object as DMPQuestion;				
				return new EqualsBuilder()
				.append(nullToString(questionContent), nullToString(other.questionContent))
					.append(nullToString(frequency), nullToString(other.frequency))
					.append(nullToString(additionalInstructions), nullToString(other.additionalInstructions))
					.append(questionResponseTermType, other.questionResponseTermType)
					.append(questionContentTermType, other.questionContentTermType)
					.append(contentOrder, other.contentOrder)
					.append(locked, other.locked)
					.append(markAsDeleted, other.markAsDeleted)					
					.equals;					
			}
			else {
				return false;
			}
			return false;
		}
		private function nullToString(a:String):String {
			return a==null ? "" : a;
		}
	}
}