package gov.va.med.ccht.ui.common.model
{
	import gov.va.med.fw.utils.EqualsBuilder;
	
	import mx.collections.ArrayList;
	import mx.collections.ArrayCollection;

	
	[Bindable] [RemoteClass(alias="gov.va.med.ccht.model.dmp.DMPFindReplaceCriteria")]
	
	public class DMPFindReplaceCriteria implements IEquals
	{
		public var findTerm:String;
		public var replaceTerm:String;
		public var highlightTerm:String;
		public var dmpAttributeLocation:Boolean=false;
		public var dmpContentLocation:Boolean=false;
		public var dmpResponseLocation:Boolean=false;
		public var results:ArrayCollection;
		public var exception:String;

		public function equals(object:Object):Boolean {
			if (!object) { return false; }
			if (object == this) { return true; }
			if (object is DMPFindReplaceCriteria) {
				var other:DMPFindReplaceCriteria = object as DMPFindReplaceCriteria;				
				return new EqualsBuilder()
				.append(nullToString(findTerm), nullToString(other.findTerm))
					.append(dmpAttributeLocation, other.dmpAttributeLocation)
					.append(highlightTerm, other.highlightTerm)
					.append(dmpContentLocation, other.dmpContentLocation)
					.append(dmpResponseLocation, other.dmpResponseLocation)
					.equals;					
			}
			else {
				return false;
			}
			return false;
		}
		private function nullToString(a:String):String {
			return a==null ? "" : a;
		}
		
	
	}
	}
