package gov.va.med.ccht.ui.common.model
{
	import gov.va.med.fw.model.TermType;
	import gov.va.med.fw.utils.EqualsBuilder;
	import gov.va.med.fw.utils.FormatUtils;
	
	import mx.collections.ArrayCollection;
	import mx.formatters.DateFormatter;
	import mx.utils.StringUtil;
	
	[Bindable] [RemoteClass(alias="gov.va.med.ccht.ui.model.DMPForm")]
	
	public class DMP extends Form implements IEquals
		
	{	public var canEdit:Boolean;	
		public var isReviewer:Boolean;
		public var isAssignee:Boolean;
		public var tag:String;
		public var name:String;
		public var description:String;
		public var objective:String;
		public var dmpVersion:String;
		public var dateCreated:Date;
		public var createdDate:Date;
		public var createdBy:String;
		public var dmpStatusType:TermType;
		public var modifiedDate:String;
		public var currentAssignees:ArrayCollection;
		public var assignees:ArrayCollection;
		public var unassignees:ArrayCollection;
		public var dmpToolUsers:ArrayCollection;
		public var dmpAssignees:String;
		public var questions:ArrayCollection;
		public var selectedQuestion:DMPQuestion;
		public var deletedQuestions:ArrayCollection;
		public var selectedResponse:DMPResponse;
		public var selectedDMPReview:DMPReview;
		public var selectedResponses:ArrayCollection;
		public var searchScreen:String;
		
		public var dmpToolUserReviewers:ArrayCollection;
		public var dmpReviewerNames:String;
		public var reviewers:ArrayCollection;
		public var hasComments:Boolean;
		//public var dmp:P_DMP;
		

		
		public function DMP()
		{
			super();
		}

		
		public function equals(object:Object):Boolean {
			if (!object) { return false; }
			if (object == this) { return true; }
			if (object is DMP) {
				var other:DMP = object as DMP;				
				return new EqualsBuilder()
				    .append(nullToString(tag), nullToString(other.tag))
					.append(nullToString(name), nullToString(other.name))
					.append(nullToString(description), nullToString(other.description))
					.append(nullToString(objective), nullToString(other.objective))
					.append(nullToString(dmpVersion), nullToString(other.dmpVersion))
					.append(dmpStatusType, other.dmpStatusType)
					.equals;					
			}
			else {
				return false;
			}
			return false;
		}
		private function nullToString(a:String):String {
			return a==null ? "" : a;
		}
		public function formatDate( date:Date ) : String {
			if( date != null ) {
				var df:DateFormatter = new DateFormatter();
				df.formatString="MM/DD/YYYY";
				return df.format(date);
			}	
			return null;
		}
	}
	
	}
		