package gov.va.med.ccht.ui.common.command {
	import mx.core.Application;
	import mx.core.FlexGlobals;
	import mx.rpc.remoting.RemoteObject;
	
	public class CchtServiceLocator {
		
		public var terminologyController : RemoteObject;
		public var securityController : RemoteObject;
		public var securityControllerNonUI : RemoteObject;
		public var inventoryController : RemoteObject;
		public var qirController : RemoteObject;
		public var reportController : RemoteObject;
		public var batchProcessController : RemoteObject;
		public var dmpController : RemoteObject;
		public var htReportController : RemoteObject;
		public var satisfactionSurveyReportController : RemoteObject;
		public var satisfactionSurveyTrendController : RemoteObject;
		public var surveyDistribtionReportController : RemoteObject;
		public var vendorSubmissionReportController : RemoteObject;
		public var vrTwelveReportController : RemoteObject;
		public var censusActivityReportController : RemoteObject;
		
		
		public function CchtServiceLocator() {
			if(cchtServiceLocator != null) {
	            throw new Error("SINGLETON_EXCEPTION CchtServiceLocator" );
	         }
			cchtServiceLocator = this;
		}
		
		private static var cchtServiceLocator:CchtServiceLocator = null;
		
		internal static function getInternalInstance() : CchtServiceLocator
		{
			return cchtServiceLocator;
		}
		
	    public static function getInstance() : CchtServiceLocator  {
	         if (cchtServiceLocator == null) {
	        	cchtServiceLocator = new CchtServiceLocator();
	        	cchtServiceLocator.terminologyController = FlexGlobals.topLevelApplication.terminologyController;
	        	cchtServiceLocator.securityController = FlexGlobals.topLevelApplication.securityController;
	        	cchtServiceLocator.securityControllerNonUI = FlexGlobals.topLevelApplication.securityControllerNonUI;
	        	cchtServiceLocator.inventoryController = FlexGlobals.topLevelApplication.inventoryController;
				cchtServiceLocator.qirController = FlexGlobals.topLevelApplication.qirController;
	        	cchtServiceLocator.reportController = FlexGlobals.topLevelApplication.reportController;
	        	cchtServiceLocator.batchProcessController = FlexGlobals.topLevelApplication.batchProcessController;
				cchtServiceLocator.dmpController = FlexGlobals.topLevelApplication.dmpController;
				cchtServiceLocator.htReportController = FlexGlobals.topLevelApplication.htReportController;
				cchtServiceLocator.satisfactionSurveyReportController = FlexGlobals.topLevelApplication.satisfactionSurveyReportController;
				cchtServiceLocator.satisfactionSurveyTrendController = FlexGlobals.topLevelApplication.satisfactionSurveyTrendController;
				cchtServiceLocator.surveyDistribtionReportController = FlexGlobals.topLevelApplication.surveyDistribtionReportController;
				cchtServiceLocator.vendorSubmissionReportController = FlexGlobals.topLevelApplication.vendorSubmissionReportController;
				cchtServiceLocator.vrTwelveReportController = FlexGlobals.topLevelApplication.vrTwelveReportController;
				cchtServiceLocator.censusActivityReportController = FlexGlobals.topLevelApplication.censusActivityReportController;
	         }
	         return cchtServiceLocator;
	      }
	}
}