/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.controller;

import gov.va.med.ccht.model.terminology.InactiveReason;
import gov.va.med.ccht.model.terminology.RegistrationStatus;
import gov.va.med.ccht.model.terminology.UserGroup;
import gov.va.med.ccht.service.common.TerminologyException;
import gov.va.med.ccht.util.AbstractCCHTTest;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.testng.annotations.Test;


public class TestTerminologyController extends AbstractCCHTTest {

	@Autowired
	private TerminologyController terminologyController = null;
	
	private static final List<Class> lookupClasses = new ArrayList<Class>();
	
	static {		
		lookupClasses.add(InactiveReason.class);
		lookupClasses.add(RegistrationStatus.class);
		lookupClasses.add(UserGroup.class);
	}

	@Test(groups = "functionalTest")
	public void testTerminologyController() throws TerminologyException {
		System.out.println("TestTerminologyController.testTerminologyController	begin");
		Assert.notNull(terminologyController);
		for (Class c : lookupClasses) {
			List lookups = terminologyController.findAll(c);
			Assert.notNull(lookups);
			System.out.println(" Count of " + c.getName() + " = " + lookups.size() );
		}
		System.out.println("TestTerminologyController.testTerminologyController	end");
	}
}
