/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.controller;

import javax.annotation.Resource;

import org.springframework.security.providers.AuthenticationProvider;
import org.springframework.util.Assert;
import org.testng.annotations.Test;

import gov.va.med.fw.security.AuthenticationToken;

import gov.va.med.ccht.util.AbstractCCHTTest;


public class TestSecurityController extends AbstractCCHTTest {

	@Resource
	private SecurityController securityController = null;
	@Resource
	private AuthenticationProvider cchtAuthenticationProvider = null;
	
	@Test(groups = "functionalTest")
	public void testSecurityController() {
		System.out.println("TestSecurityController.testSecurityController	begin");
		Assert.notNull(securityController);
		AuthenticationToken token = (AuthenticationToken) new AuthenticationToken(
				"IHTA1", "Password1!");
		token = (AuthenticationToken)cchtAuthenticationProvider.authenticate(token);
		Assert.notNull(token);
		Assert.isTrue(token.isLoggedIn());
		System.out.println("TestSecurityController.testSecurityController	end");
	}
}
