package gov.va.med.ccht.controller;

import gov.va.med.ccht.model.inventory.Device;
import gov.va.med.ccht.model.inventory.Facility;
import gov.va.med.ccht.model.inventory.Vendor;
import gov.va.med.ccht.model.inventory.Visn;
import gov.va.med.ccht.ui.common.ControllerException;
import gov.va.med.ccht.util.AbstractCCHTTest;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.util.Assert;
import org.testng.annotations.Test;

public class TestInventoryController extends AbstractCCHTTest {
	@Resource
	private InventoryController inventoryController = null;
	
	@Test(groups = "functionalTest")
	public void testInventoryController() throws ControllerException {
		System.out.println("TestInventoryController.testInventoryController	begin");
		Assert.notNull(inventoryController);
		List<Device> devices = inventoryController.getDevices();
		Assert.notNull(devices);
		System.out.println("#Devices: " + devices.size());
		List<Facility> facilities = inventoryController.getFacilities();
		Assert.notNull(facilities);
		System.out.println("#Facilities: " + facilities.size());
		List<Vendor> vendors = inventoryController.getVendors();
		Assert.notNull(vendors);
		System.out.println("#Vendors: " + vendors.size());
		List<Visn> visns = inventoryController.getVisns();
		Assert.notNull(visns);
		System.out.println("#Visns: " + visns.size());	
		for (Visn visn: visns) {
			System.out.println("Visn: " + visn.getName() + " Facilities: " + 
					(visn.getFacilities() == null ? 0 : visn.getFacilities().size()));
		}
		System.out.println("TestInventoryController.testInventoryController	end");
	}
}
