package gov.va.med.ccht.ui.struts;

import java.util.List;

import edu.emory.mathcs.backport.java.util.Collections;

import gov.va.med.fw.model.ldap.LdapPerson;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;

import gov.va.med.ccht.model.AppUserGroup;
import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.inventory.SimpleFacility;
import gov.va.med.ccht.model.inventory.SimpleVisn;
import gov.va.med.ccht.model.inventory.Vendor;
import gov.va.med.ccht.model.terminology.RegistrationStatus;
import gov.va.med.ccht.model.terminology.RegistrationReason;
import gov.va.med.ccht.model.terminology.UserGroup;
import gov.va.med.ccht.service.common.JobDescription;
import gov.va.med.ccht.service.common.RegistrationService;
import gov.va.med.ccht.service.common.SecurityService;
import gov.va.med.ccht.service.common.TerminologyService;
import gov.va.med.ccht.service.inventory.InventoryService;

public class RegistrationAction extends AbstractAction {

	private static final long serialVersionUID = -1876651775925283907L;

	private RegistrationService registrationService;
	private SecurityService securityService;
	private TerminologyService terminologyService;
	private InventoryService inventoryService;
	
	private Boolean registerSubmit;
	private Boolean displayVISN;
	private Boolean displayFacility;
	private Boolean displayVendor;
	
	// VA User attributes
	private String username;
	private String visn;
	private String facility;
	private String vendor;
	private String reason;

	private static final String MESSAGE_REG_FIELD_REQUIRED = "field.required";
	private static final String MESSAGE_REG_ACCOUNT_NOTFOUND = "user.notfound";
	private static final String MESSAGE_REG_ACCOUNT_EXISTS = "user.found";
	private static final String MESSAGE_REGISTRATION_APPROVED = "registration.approved";	
	private static final String MESSAGE_REGISTRATION_DENIED = "registration.denied";
	private static final String MESSAGE_REGISTRATION_PENDING = "registration.pending";
	private static final String COMPLETION = "completion";
	private static final String MESSAGE_VISN_FACILITY_REQUIRED = "select.visn.or.facility";
	
	private enum DisplayField {
		VISN, FACILITY, VENDOR;
	}
	
	// Validate and process registration only if the user clicks on register
	public String register() {
		
		// Validate and process a registration wizard 1 of 2
		if( registerSubmit != null && registerSubmit ) {
			// Validate required fields
			if ( StringUtils.isEmpty(getUsername()) || StringUtils.isEmpty(getReason()) ) {
				if( StringUtils.isEmpty(getUsername()) ) {
					addActionError(getText(MESSAGE_REG_FIELD_REQUIRED, new String[]{"User Name"}));
				}
				if ( StringUtils.isEmpty(getReason()) ) {
					addActionError(getText(MESSAGE_REG_FIELD_REQUIRED, new String[]{"Job Description"}));
				}
				// Management (4) or NAC (6) or DMP Contributor (7) or STTC Staff (8)
				if( StringUtils.equals("4", getReason()) || StringUtils.equals("6", getReason()) || StringUtils.equals("7", getReason()) || StringUtils.equals("8", getReason()) ) {
					getRequest().setAttribute( "REGISTRATIONBUTTON", Boolean.TRUE.toString() );  
				}
				return ERROR;
			}
			else {
				// Check to see if the provided user name is valid
				// Authenticate the user and get the user details
				try {
					String username = getUsername();
					User oldUser = securityService.getUser(username);
					if (oldUser != null) {
						//verify the registration status
						RegistrationStatus regStatus = oldUser.getRegistrationStatus();
						if (regStatus == null) {
							addActionError(getText(MESSAGE_REG_ACCOUNT_EXISTS));
						}
						else if (RegistrationStatus.REJECTED.equalsIgnoreCase(regStatus.getCode())) {
							addActionError(getText(MESSAGE_REGISTRATION_DENIED));
						}	
						else if (RegistrationStatus.SUBMITTED.equalsIgnoreCase(regStatus.getCode())) {
							addActionError(getText(MESSAGE_REGISTRATION_PENDING));
						}
						else if (RegistrationStatus.APPROVED.equalsIgnoreCase(regStatus.getCode())) {
							addActionError(getText(MESSAGE_REGISTRATION_APPROVED));
						}
						// Management (4) or NAC (6) or DMP Contributor (7) or STTC Staff (8)
						if( StringUtils.equals("4", getReason()) || StringUtils.equals("6", getReason()) || StringUtils.equals("7", getReason()) || StringUtils.equals("8", getReason()) ) {
							getRequest().setAttribute( "REGISTRATIONBUTTON", Boolean.TRUE.toString() );  
						}
						return ERROR;
					} 
					else {
						LdapPerson ldapPerson = securityService.getLdapUser(username);
						if (ldapPerson != null) {
							getRequest().setAttribute("username", username );
							getRequest().setAttribute("reason", getReason() );
							if( StringUtils.equals( JobDescription.CARE_COORDINATOR.getValue(), getReason()) 
							 || StringUtils.equals( JobDescription.PSA.getValue(), getReason() ) ) {
								getRequest().setAttribute( DisplayField.FACILITY.name(), DisplayField.FACILITY.name() );
								getFacilities();
							}
							else if ( StringUtils.equals( JobDescription.LEAD_CARE_COORDINATOR.getValue(), getReason()) ) {
								getRequest().setAttribute( DisplayField.VISN.name(), DisplayField.VISN.name() );  
								getRequest().setAttribute( DisplayField.FACILITY.name(), DisplayField.FACILITY.name() );
								getVisns();
								getFacilities();
							}
							else if( StringUtils.equals( JobDescription.VENDOR.getValue(), getReason()) ) {
								getRequest().setAttribute( DisplayField.VENDOR.name(), DisplayField.VENDOR.name() );
								getVendors();
							}
							else if( StringUtils.equals( JobDescription.NAC.getValue(), getReason()) 
			 					 || StringUtils.equals( JobDescription.MANAGEMENT.getValue(), getReason())
			 					 || StringUtils.equals( JobDescription.DMP_CONTRIBUTOR.getValue(), getReason())
			 					 || StringUtils.equals( JobDescription.STTC_STAFF.getValue(), getReason())
							) {
								return processVARegistration(username, getReason());
							}
							return SUCCESS;
						} 
						else {
							addActionError(getText(MESSAGE_REG_ACCOUNT_NOTFOUND));
							// Management (4) or NAC (6) or DMP Contributor (7) or STTC Staff (8)
							if( StringUtils.equals("4", getReason()) || StringUtils.equals("6", getReason()) || StringUtils.equals("7", getReason()) || StringUtils.equals("8", getReason()) ) {
								getRequest().setAttribute( "REGISTRATIONBUTTON", Boolean.TRUE.toString() );  
							}
							return ERROR;
						}
					}
				}
				catch( ServiceException e ) {
					addActionError(getText(MESSAGE_REG_ACCOUNT_NOTFOUND));
					// Management (4) or NAC (6) or DMP Contributor (7) or STTC Staff (8)
					if( StringUtils.equals("4", getReason()) || StringUtils.equals("6", getReason()) || StringUtils.equals("7", getReason()) || StringUtils.equals("8", getReason()) ) {
						getRequest().setAttribute( "REGISTRATIONBUTTON", Boolean.TRUE.toString() );  
					}
					return ERROR;
				}
			}
		}
		else {
			// Display a registration wizard 1 of 2
			// to capture user name and reason
			getRegistrationReasons();
			return INPUT;
		}
	}

	public String registerVAUser() throws Exception {
		
		// For CC and PSA, validate facility
		// For Lead CC, validate VISN, and facility
		// For vendor, validate vendor
		setRequestAttributes();
		
		if( Boolean.TRUE.equals( this.displayVISN ) && Boolean.TRUE.equals( this.displayFacility ) ) {
			if( StringUtils.isEmpty( this.getVisn() ) && StringUtils.isEmpty( this.getFacility() ) ) {
				addActionError(getText(MESSAGE_VISN_FACILITY_REQUIRED));
			}
		}

		if( !Boolean.TRUE.equals( this.displayVISN ) && Boolean.TRUE.equals( this.displayFacility ) ) {
			if( StringUtils.isEmpty( this.getFacility() ) ) {
				addActionError(getText(MESSAGE_REG_FIELD_REQUIRED, new String[]{"Facility"}));
			}
		}
		
		if( Boolean.TRUE.equals( this.displayVendor ) ) {
			if( StringUtils.isEmpty( this.getVendor() ) ) {
				addActionError(getText(MESSAGE_REG_FIELD_REQUIRED, new String[]{"Vendor"}));
			}
		}
		
		//Return to input if there are errors
		if (getActionErrors().size() > 0) {
			return INPUT;
		}
		else {
			// Just in case there are errors, put back request attributes
			return processVARegistration(getUsername(),getReason());
		}
	}

	public RegistrationService getRegistrationService() {
		return registrationService;
	}

	public void setRegistrationService(RegistrationService registrationService) {
		this.registrationService = registrationService;
	}

	public SecurityService getSecurityService() {
		return securityService;
	}

	public void setSecurityService(SecurityService securityService) {
		this.securityService = securityService;
	}

	public TerminologyService getTerminologyService() {
		return terminologyService;
	}

	public void setTerminologyService(TerminologyService terminologyService) {
		this.terminologyService = terminologyService;
	}

	public InventoryService getInventoryService() {
		return inventoryService;
	}

	public void setInventoryService(InventoryService inventoryService) {
		this.inventoryService = inventoryService;
	}

	public Boolean getRegisterSubmit() {
		return registerSubmit;
	}

	public void setRegisterSubmit(Boolean registerSubmit) {
		this.registerSubmit = registerSubmit;
	}

	public void setDisplayVISN(Boolean displayVISN) {
		this.displayVISN = displayVISN;
	}

	public Boolean getDisplayVISN() {
		return displayVISN;
	}

	public void setDisplayFacility(Boolean displayFacility) {
		this.displayFacility = displayFacility;
	}

	public Boolean getDisplayFacility() {
		return displayFacility;
	}

	public void setDisplayVendor(Boolean displayVendor) {
		this.displayVendor = displayVendor;
	}

	public Boolean getDisplayVendor() {
		return displayVendor;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getVisn() {
		return visn;
	}

	public void setVisn(String visn) {
		this.visn = visn;
	}
	
	public String getFacility() {
		return facility;
	}

	public void setFacility(String facility) {
		this.facility = facility;
	}

	public String getVendor() {
		return vendor;
	}

	public void setVendor(String vendor) {
		this.vendor = vendor;
	}

	public String getReason() {
		return reason;
	}

	public void setReason(String reason) {
		this.reason = reason;
	}

	@SuppressWarnings("unchecked")
	public List<SimpleVisn> getVisns() {
		List<SimpleVisn> visns = (List<SimpleVisn>)getServletContext().getAttribute("visns");
		if (visns == null) {
			try {
				visns = inventoryService.getSimpleVisns();
				getServletContext().setAttribute("visns",visns);
			}catch (Exception e){
				logger.error("InventoryService.getSimpleVisns failed " + e.getMessage(), e);
			}
		}
		return visns;
	}
	
	@SuppressWarnings("unchecked")	
	public List<SimpleFacility> getFacilities() {
		List<SimpleFacility> facilities = (List<SimpleFacility>)getServletContext().getAttribute("facilities");
		if (facilities == null) {
			try {
				facilities = inventoryService.getSimpleFacilities();
				Collections.sort(facilities);
				getServletContext().setAttribute("facilities",facilities);
			}catch (Exception e){
				logger.error("InventoryService.getSimpleFacilities failed " + e.getMessage(), e);
			}
		}
		return facilities;
	}	
	
	@SuppressWarnings("unchecked")	
	public List<RegistrationReason> getRegistrationReasons() {
		List<RegistrationReason> registrationReasons = (List<RegistrationReason>)getServletContext().getAttribute("registrationReasons");
		if (registrationReasons == null) {
			try {
				registrationReasons = terminologyService.findAll(RegistrationReason.class);
				getServletContext().setAttribute("registrationReasons",registrationReasons);
			}catch (Exception e){
				logger.error("terminologyService.findAll failed for RegistrationReason. " + e.getMessage(), e);
			}
		}
		return registrationReasons;
	}
	
	@SuppressWarnings("unchecked")
	public List<Vendor> getVendors() {
		List<Vendor> vendors = (List<Vendor>)getServletContext().getAttribute("vendors");
		if (vendors == null) {
			try {
				vendors = inventoryService.getVendors();
				getServletContext().setAttribute("vendors",vendors);
			}catch (Exception e){
				logger.error("inventoryService.getVendors failed. " + e.getMessage(), e);
			}
		}
		return vendors;
	}
	
	private String processVARegistration(String username, String reason) {
		
		try {
			User oldUser = securityService.getUser(username);
			if (oldUser != null) {
				//verify the registration status
				RegistrationStatus regStatus = oldUser.getRegistrationStatus();
				if (regStatus == null) {
					addActionError(getText(MESSAGE_REG_ACCOUNT_EXISTS));
				}
				else if (RegistrationStatus.REJECTED.equalsIgnoreCase(regStatus.getCode())) {
					addActionError(getText(MESSAGE_REGISTRATION_DENIED));
				}	
				else if (RegistrationStatus.SUBMITTED.equalsIgnoreCase(regStatus.getCode())) {
					addActionError(getText(MESSAGE_REGISTRATION_PENDING));
				}
				else if (RegistrationStatus.APPROVED.equalsIgnoreCase(regStatus.getCode())) {
					addActionError(getText(MESSAGE_REGISTRATION_APPROVED));
				}					
			} 
			else {
				// Authenticate the user and get the user details
				LdapPerson ldapPerson = securityService.getLdapUser(username);
				
				if (ldapPerson != null) {
					// create user and send e-mails to admin and users
					User user = new User(ldapPerson.getSamAccountName());
					user.setLdapPerson(ldapPerson);						
					
					//Group
					UserGroup ug = terminologyService.getByCode(UserGroup.class, UserGroup.VA_USER);
					AppUserGroup aug = new AppUserGroup();
					aug.setUserGroup(ug);
					user.addUserGroup(aug);

					user.setLoginFailedCount(0);
					RegistrationStatus regStatus = terminologyService.getByCode(RegistrationStatus.class,
																				RegistrationStatus.SUBMITTED);
					user.setRegistrationStatus(regStatus);
					if (StringUtils.isNotEmpty(getReason())) {
						user.setRegistrationReason(terminologyService.getByCode(RegistrationReason.class, reason));
					}
					if (StringUtils.isNotEmpty(getVisn())) {
						user.setVisn(inventoryService.getSimpleVisn(getVisn()));
					}
					if (StringUtils.isNotEmpty(getFacility())) {
						user.setFacility(inventoryService.getSimpleFacility(getFacility()));
						user.setVisn(user.getFacility().getVisn());
					}
					if (StringUtils.isNotEmpty(getVendor())) {
						user.setVendor(inventoryService.getVendor(getVendor()));				
					}
					registrationService.addVAUser(user);
					return COMPLETION;
				} 
				else {
					addActionError(getText(MESSAGE_REG_ACCOUNT_NOTFOUND));
				}
			}
		} 
		catch (Exception ae) {
			handleException(ae, this);
			addActionError(getText(MESSAGE_SYSTEM_ERROR));
		}
		return INPUT;
	}

	private void setRequestAttributes() {
		if( Boolean.TRUE.equals( this.displayFacility ) ) {
			getRequest().setAttribute( DisplayField.FACILITY.name(), DisplayField.FACILITY.name() );  
		}
		
		if( Boolean.TRUE.equals( this.displayVISN ) ) {
			getRequest().setAttribute( DisplayField.VISN.name(), DisplayField.VISN.name() );  
		}

		if( Boolean.TRUE.equals( this.displayVendor ) ) {
			getRequest().setAttribute( DisplayField.VENDOR.name(), DisplayField.VENDOR.name() );  
		}
		getRequest().setAttribute("username", getUsername() );
		getRequest().setAttribute("reason", getReason() );
		getActionErrors().clear();
	}
}