package gov.va.med.ccht.ui.struts;

import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.springframework.beans.factory.InitializingBean;

import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.Preparable;

import gov.va.med.fw.model.lookup.SeverityType;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.config.EnvironmentParamService;
import gov.va.med.fw.ui.UIConstants;
import gov.va.med.fw.ui.conversion.ConversionService;

public abstract class AbstractAction extends ActionSupport implements ServletRequestAware,
		ServletResponseAware, Preparable, InitializingBean {

	private static final long serialVersionUID = -6987221568427816449L;
	public static final String MESSAGE_SYSTEM_ERROR = "System Error: Please contact your System Administrator.";

	private HttpServletRequest request = null;
	private HttpServletResponse response = null;

	//private ExceptionService exceptionService;

	protected ConversionService conversionService;

	//private IHTASession IHTASession;
	
	private EnvironmentParamService environmentParamService;

	protected transient Log logger = LogFactory.getLog(getClass());

	public void prepare() throws Exception {
		// TODO Auto-generated method stub
	}

	public void setServletRequest(HttpServletRequest request) {
		this.request = request;
		/*IHTASession.setHttpSessionProvider(this);
		
		ServletContext context = getServletContext();
		if(context.getAttribute(IHTAConstants.IHTA_IS_PROD_ENV) == null) {
			// set it once in context
			context.setAttribute(IHTAConstants.IHTA_IS_PROD_ENV, environmentParamService.isProdEnv());
		}*/
	}
	
	protected boolean isProdEnv() {
		//ServletContext context = getServletContext();
		//return Boolean.parseBoolean((String) context.getAttribute(IHTAConstants.IHTA_IS_PROD_ENV));
		return false;
	}

	public HttpServletRequest getServletRequest() {
		return request;
	}

	public ServletContext getServletContext() {
		return request != null ? request.getSession().getServletContext() : null;
	}

	protected Map<?, ?> getApplicationData() {
		return (Map<?, ?>) request.getAttribute(UIConstants.APP_DATA);
	}

	protected void setApplicationData(Map<?, ?> applicationData) {
		request.setAttribute(UIConstants.APP_DATA, applicationData);
	}

	public ConversionService getConversionService() {
		return conversionService;
	}

	public void setConversionService(ConversionService conversionService) {
		this.conversionService = conversionService;
	}

	public Log getLogger() {
		return logger;
	}

	public void setLogger(Log logger) {
		this.logger = logger;
	}

	public HttpServletRequest getRequest() {
		return request;
	}

	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}

	protected void setSecurityContext(SecurityContext context) {
		if (request != null)
			request.setAttribute(UIConstants.SECURITY_CONTEXT, context);
	}

	protected SecurityContext getSecurityContext() {
		return request != null ? (SecurityContext) request
				.getAttribute(UIConstants.SECURITY_CONTEXT) : null;
	}

	protected UserPrincipal getLoggedInUser() {
		SecurityContext securityContext = SecurityContextHelper.getSecurityContext();
		return (securityContext != null) ? securityContext.getUserPrincipal() : null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.IHTA.ui.HttpSessionProvider#getHttpSession()
	 */
	public HttpSession getHttpSession() {
		return this.getRequest().getSession();
	}

	protected void handleException(Exception exception, Object producer) {
		handleException(null, exception, producer);
	}

	protected void handleException(String message, Exception exception, Object producer) {
		handleException(message, exception, producer, SeverityType.ERROR);
	}

	protected void handleException(String message, Exception exception, Object producer,
			SeverityType severityType) {
		logger.error(message, exception);
	}

	public void setServletResponse(HttpServletResponse response) {
		this.response = response;
	}

	public HttpServletResponse getServletResponse() {
		return this.response;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
	 */
	public void afterPropertiesSet() throws Exception {
	}


	public EnvironmentParamService getEnvironmentParamService() {
		return environmentParamService;
	}

	public void setEnvironmentParamService(
			EnvironmentParamService environmentParamService) {
		this.environmentParamService = environmentParamService;
	}
}
