/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.ui.model;

import java.util.Date;

import gov.va.med.fw.util.date.DateWithTimeZone;
import gov.va.med.fw.util.date.TimeZoneUtils;

/**
 * Useful to preserve custom Date formatting (eg, track dates with original
 * TimeZone formatting)
 * 
 * Oct 24, 2010
 * 
 * @author VHAISWBOHMEG
 */
public class FormattedDateForm {
	private Date date;
	private String formattedDate;

	/**
	 * @return the date
	 */
	public Date getDate() {
		return date;
	}

	/**
	 * @param date
	 *            the date to set
	 */
	public void setDate(Date date) {
		this.date = date;
	}

	/**
	 * @return the formattedDate
	 */
	public String getFormattedDate() {
		return formattedDate;
	}

	/**
	 * @param formattedDate
	 *            the formattedDate to set
	 */
	public void setFormattedDate(String formattedDate) {
		this.formattedDate = formattedDate;
	}

	public FormattedDateForm() {
		super();
	}

	public FormattedDateForm(DateWithTimeZone dwtz) {
		super();
		if (dwtz != null) {
			setDate(dwtz.getDate());
			setFormattedDate(TimeZoneUtils.convertDateToTimeZone(dwtz));
		}
	}
}
