package gov.va.med.ccht.ui.model;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.util.TimeZone;

import gov.va.med.fw.ui.model.Form;
import gov.va.med.fw.ui.model.TermType;
import gov.va.med.fw.util.date.TimeZoneUtils;
import gov.va.med.ccht.model.dmp.DMP;
import gov.va.med.ccht.model.dmp.DMPSearch;
import gov.va.med.ccht.model.dmp.DMPToolUser;
import gov.va.med.ccht.model.dmp.DMPQuestion;
import gov.va.med.ccht.model.dmp.DMPResponse;

public class DMPSearchForm extends Form {
	private Boolean canEdit;

	private String createdBy;
	private String modifiedBy;
	private TermType dmpStatusType;
	private DMPSearch dmp = new DMPSearch();
	private List<DMPSearch> dmps = new ArrayList<DMPSearch>();
	private String modifiedDate;
	private List<DmpAssignee> assignees = new ArrayList<DmpAssignee>();
	private List<DMPToolUser> unassignees = new ArrayList<DMPToolUser>();
		
	public List<DMPToolUser> getUnassignees() {
		return unassignees;
	}

	public void setUnassignees(List<DMPToolUser> unassignees) {
		this.unassignees = unassignees;
	}

	private List<DMPToolUser> dmpToolUsers = new ArrayList<DMPToolUser>();
	private String dmpAssignees;

	public String getTag() {
		return dmp.getTag();
	}

	public void setTag(String tag) {
		dmp.setTag(tag);
	}

	public String getName() {
		return dmp.getName();
	}

	public void setName(String name) {
		dmp.setName(name);
	}

	public String getDescription() {
		return dmp.getDescription();
	}

	public void setDescription(String description) {
		dmp.setDescription(description);
	}

	public String getObjective() {
		return dmp.getObjective();
	}

	public void setObjective(String objective) {
		dmp.setObjective(objective);
	}

	public Date getDateCreated() {
		return dmp.getDateCreated();
	}

	public void setDateCreated(Date dateCreated) {
		dmp.setDateCreated(dateCreated);
	}

	public String getCreatedBy() {
		return createdBy;
	}

	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	public String getModifiedBy() {
		return modifiedBy;
	}

	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	public Date getCreatedDate() {
		return dmp.getCreatedOn();
	}

	public void setCreatedDate(Date createdDate) {
	}

	public void setDmpStatusType(TermType dmpStatusType) {
		this.dmpStatusType = dmpStatusType;
	}

	public TermType getDmpStatusType() {
		return dmpStatusType;
	}

	public DMPSearch getDmp() {
		return dmp;
	}

	public void setDmp(DMPSearch dmp) {
		this.dmp = dmp;
	}

	public List<DMPSearch> getDmps() {
		return dmps;
	}

	public void setDmps(List<DMPSearch> dmps) {
		this.dmps = dmps;
	}

	public String getModifiedDate() {
		modifiedDate = (TimeZoneUtils.convertDateToTimeZone(
				dmp.getModifiedOn(), TimeZone.getDefault()));
		return modifiedDate;
	}

	public void setModifiedDate(String modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public List<DmpAssignee> getAssignees() {
		return assignees;
	}

	public void setAssignees(List<DmpAssignee> assignees) {
		this.assignees = assignees;
	}

	public List<DMPToolUser> getDmpToolUsers() {
		return dmpToolUsers;
	}

	public void setDmpToolUsers(List<DMPToolUser> dmpToolUsers) {
		this.dmpToolUsers = dmpToolUsers;
	}

	public String getDmpAssignees() {
		return this.dmpAssignees;
	}

	public void setDmpAssignees(String dmpAssignees) {
		this.dmpAssignees = dmpAssignees;
	}
	public String getQuestion() {
		return dmp.getQuestion();
	}

	public void setQuestion(String question) {
		dmp.setQuestion(question);
	}
	public String getResponse() {
		return dmp.getResponse();
	}

	public void setResponse(String response) {
		dmp.setResponse(response);
	}

	public Boolean getCanEdit() {
		return canEdit;
	}

	public void setCanEdit(Boolean canEdit) {
		this.canEdit = canEdit;
	}
	public String getFacilitator() {
		return dmp.getCreatedByName();
	}

	public void setFacilitator(String facilitator) {
		dmp.setCreatedByName(facilitator);
	}
	public String getAssignee() {
		return dmp.getAssignee();
	}

	public void setAssignee(String assignee) {
		dmp.setAssignee(assignee);
	}
	
	public boolean isHasComments() {
		return dmp.isHasComments();
	}

	public boolean getHasComments() {
		return dmp.isHasComments();
	}
	
	public void setHasComments(boolean hasComments) {
		dmp.setHasComments(hasComments);
	}
}
