package gov.va.med.ccht.ui.model;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.util.TimeZone;

import gov.va.med.fw.ui.model.Form;
import gov.va.med.fw.ui.model.TermType;
import gov.va.med.fw.util.date.TimeZoneUtils;
import gov.va.med.ccht.model.dmp.DMP;
import gov.va.med.ccht.model.dmp.DMPReview;
import gov.va.med.ccht.model.dmp.DMPToolUser;
import gov.va.med.ccht.model.dmp.DMPQuestion;
import gov.va.med.ccht.model.dmp.DMPResponse;

public class DMPForm extends Form {
	private Boolean canEdit;
	private boolean isReviewer = false;
	private boolean isAssignee = false;
	
	private String createdBy;
	private String modifiedBy;
	private TermType dmpStatusType;
	private DMP dmp = new DMP();
	private List<DMP> dmps = new ArrayList<DMP>();
	private String modifiedDate;
	private List<DmpAssignee> assignees = new ArrayList<DmpAssignee>();
	private List<DMPToolUser> unassignees = new ArrayList<DMPToolUser>();
	private List<DMPQuestion> questions = new ArrayList<DMPQuestion>();
	private List<DMPQuestion> deletedQuestions = new ArrayList<DMPQuestion>();
	private DMPQuestion selectedQuestion= new DMPQuestion();
	private DMPResponse selectedResponse = new DMPResponse();
	private DMPReview selectedDMPReview= new DMPReview();
	private List<DMPResponse> selectedResponses = new ArrayList<DMPResponse>();
	private String searchScreen;
	private List<DMPToolUser> dmpToolUserReviewers = new ArrayList<DMPToolUser>();
	private String dmpReviewerNames;
	
	private List<DmpAssignee> reviewers = new ArrayList<DmpAssignee>();
	private boolean hasComments;
	
	public List<DMPToolUser> getUnassignees() {
		return unassignees;
	}

	public void setUnassignees(List<DMPToolUser> unassignees) {
		this.unassignees = unassignees;
	}

	private List<DMPToolUser> dmpToolUsers = new ArrayList<DMPToolUser>();
	private String dmpAssignees;
	
	public String getTag() {
		return dmp.getTag();
	}

	public void setTag(String tag) {
		dmp.setTag(tag);
	}

	public String getName() {
		return dmp.getName();
	}

	public void setName(String name) {
		dmp.setName(name);
	}

	public String getDescription() {
		return dmp.getDescription();
	}

	public void setDescription(String description) {
		dmp.setDescription(description);
	}

	public String getObjective() {
		return dmp.getObjective();
	}

	public void setObjective(String objective) {
		dmp.setObjective(objective);
	}

/*	public Date getDateModified() {
		return dmp.getModifiedOn();
	}

	public void setDateModified(Date dateModified) {
		dmp.setModifiedOn(dateModified);
	}
*/
	public Date getDateCreated() {
		return dmp.getDateCreated();
	}

	public void setDateCreated(Date dateCreated) {
		dmp.setDateCreated(dateCreated);
	}

	public String getCreatedBy() {
		return createdBy;
	}

	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	public String getModifiedBy() {
		return modifiedBy;
	}

	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	public Date getCreatedDate() {
		return dmp.getCreatedOn();
	}

	public void setCreatedDate(Date createdDate) {
	}

	public void setDmpStatusType(TermType dmpStatusType) {
		this.dmpStatusType = dmpStatusType;
	}

	public TermType getDmpStatusType() {
		return dmpStatusType;
	}

	public DMP getDmp() {
		return dmp;
	}

	public void setDmp(DMP dmp) {
		this.dmp = dmp;
	}

	public List<DMP> getDmps() {
		return dmps;
	}

	public void setDmps(List<DMP> dmps) {
		this.dmps = dmps;
	}

	public String getModifiedDate() {
		modifiedDate = (TimeZoneUtils.convertDateToTimeZone(
				dmp.getModifiedOn(), TimeZone.getDefault()));
		return modifiedDate;
	}

	public void setModifiedDate(String modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public List<DmpAssignee> getAssignees() {
		return assignees;
	}

	public void setAssignees(List<DmpAssignee> assignees) {
		this.assignees = assignees;
	}

	public List<DMPToolUser> getDmpToolUsers() {
		return dmpToolUsers;
	}

	public void setDmpToolUsers(List<DMPToolUser> dmpToolUsers) {
		this.dmpToolUsers = dmpToolUsers;
	}

	public String getDmpAssignees() {
		return this.dmpAssignees;
	}

	public void setDmpAssignees(String dmpAssignees) {
		this.dmpAssignees = dmpAssignees;
	}

	public List<DMPQuestion> getQuestions() {
		return questions;
	}

	public void setQuestions(List<DMPQuestion> questions) {
		this.questions = questions;
	}

	public DMPQuestion getSelectedQuestion() {
		return selectedQuestion;
	}

	public void setSelectedQuestion(DMPQuestion selectedQuestion) {
		this.selectedQuestion = selectedQuestion;
	}

	public List<DMPQuestion> getDeletedQuestions() {
		return deletedQuestions;
	}

	public void setDeletedQuestions(List<DMPQuestion> deletedQuestions) {
		this.deletedQuestions = deletedQuestions;
	}

	public DMPResponse getSelectedResponse() {
		return selectedResponse;
	}

	public void setSelectedResponse(DMPResponse selectedResponse) {
		this.selectedResponse = selectedResponse;
	}

	public List<DMPResponse> getSelectedResponses() {
		return selectedResponses;
	}

	public void setSelectedResponses(List<DMPResponse> selectedResponses) {
		this.selectedResponses = selectedResponses;
	}
	public Boolean getCanEdit() {
		return canEdit;
	}

	public void setCanEdit(Boolean canEdit) {
		this.canEdit = canEdit;
	}

	public String getSearchScreen() {
		return searchScreen;
	}

	public void setSearchScreen(String searchScreen) {
		this.searchScreen = searchScreen;
	}
	public String getDmpVersion() {
		return dmp.getDmpVersion();
	}

	public void setDmpVersion(String dmpVersion) {
		dmp.setDmpVersion(dmpVersion);
	}

	public boolean isIsReviewer() {
		return isReviewer;
	}
	
	public boolean getIsReviewer() {
		return isReviewer;
	}
	public void setIsReviewer(boolean isReviewer) {
		this.isReviewer = isReviewer;
	}

	public List<DMPToolUser> getDmpToolUserReviewers() {
		return dmpToolUserReviewers;
	}

	public void setDmpToolUserReviewers(List<DMPToolUser> dmpToolUserReviewers) {
		this.dmpToolUserReviewers = dmpToolUserReviewers;
	}

	public String getDmpReviewerNames() {
		return dmpReviewerNames;
	}

	public void setDmpReviewerNames(String dmpReviewerNames) {
		this.dmpReviewerNames = dmpReviewerNames;
	}

	public List<DmpAssignee> getReviewers() {
		return reviewers;
	}

	public void setReviewers(List<DmpAssignee> reviewers) {
		this.reviewers = reviewers;
	}

	public DMPReview getSelectedDMPReview() {
		return selectedDMPReview;
	}

	public void setSelectedDMPReview(DMPReview selectedDMPReview) {
		this.selectedDMPReview = selectedDMPReview;
	}

	public boolean isHasComments() {
		return hasComments;
	}
	public boolean getHasComments() {
		return hasComments;
	}
	public void setHasComments(boolean hasComments) {
		this.hasComments = hasComments;
	}

	public boolean isIsAssignee() {
		return isAssignee;
	}
	public boolean getIsAssignee() {
		return isAssignee;
	}
	public void setIsAssignee(boolean isAssignee) {
		this.isAssignee = isAssignee;
	}
	
}
