package gov.va.med.ccht.ui.common;


import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import flex.messaging.FlexContext;

/**
 * Several methods depend on internal ThreadLocal management by Flex (BlazeDS)
 * 
 * Aug 29, 2010
 * 
 * @author VHAISWBOHMEG
 */
public class FlexUtils {

	public static ServletContext getServletContext() {
		return FlexContext.getServletContext();
	}

	/**
	 * Gets the HttpRequest object.
	 */
	public static HttpServletRequest getHttpRequest() {
		return FlexContext.getHttpRequest();
	}

	public static HttpSession getHttpSession() {
		HttpServletRequest request = getHttpRequest();
		return (request != null) ? request.getSession() : null;
	}
}
