package gov.va.med.ccht.ui.common;

import gov.va.med.ccht.model.terminology.ApplicationName;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.lookup.SeverityType;
import gov.va.med.fw.util.VersionInfo;

/**
 * OHRS_ui July 29, 2010
 * 
 * @author Muddaiah Ranga
 */
public class CommonController extends AbstractController {

	private VersionInfo versionInfo;

	public String getVersion() throws ControllerException {
		try {
			return versionInfo.getVersion();
		} catch (Exception ex) {
			throw handleException("Error while getting version info.", ex, this);
		}
	}

	public AppError logException(AppError error) {
		String message = error.getMessage();
		ControllerException cEx = new ControllerException(message);
		EntityKey key = getExceptionService().processException(cEx, message, this,
				SeverityType.ERROR, ApplicationName.CCHT);
		error.setExceptionId(key != null ? key.getKeyValueAsString() : null);
		logger.error(cEx);
		return error;
	}

	public VersionInfo getVersionInfo() {
		return versionInfo;
	}

	public void setVersionInfo(VersionInfo versionInfo) {
		this.versionInfo = versionInfo;
	}
}
