package gov.va.med.ccht.ui.common;

import gov.va.med.ccht.model.CCHTRoles;
import gov.va.med.ccht.model.Schedule;
import gov.va.med.ccht.service.common.ExceptionService;
import gov.va.med.ccht.service.common.RegistrationService;
import gov.va.med.ccht.service.common.SecurityService;
import gov.va.med.ccht.service.common.TerminologyCache;
import gov.va.med.ccht.service.common.TerminologyException;
import gov.va.med.ccht.service.dmp.DMPService;
import gov.va.med.ccht.service.inventory.InventoryService;
import gov.va.med.ccht.service.qir.QIRService;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.model.lookup.SeverityType;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceOptimisticLockException;
import gov.va.med.fw.ui.model.TermType;

import java.io.Serializable;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.Validate;
import org.springframework.orm.hibernate3.HibernateOptimisticLockingFailureException;

/**
 * This is the base class all the UI services should extend. It provides basic
 * facilities needed for all the UI services like access to ServletContext,
 * Logged in user, currently selected Patient and ...
 * 
 * @author Muddaiah Ranga
 */
public class AbstractController extends AbstractComponent implements CCHTRoles { //implements HttpSessionProvider {
	//private IHTASession IHTASession;

	private ExceptionService exceptionService;
	private TerminologyCache terminologyCache;
	private InventoryService inventoryService;
	private RegistrationService registrationService;
	private SecurityService securityService;
	private QIRService qirService;
	private DMPService dmpService;

	/**
	 * Gets the HttpRequest object.
	 */
	protected HttpServletRequest getHttpRequest() {
		return FlexUtils.getHttpRequest();
	}

	/**
	 * Gets the UserPrincipal object for the logged in user.
	 */
	protected String getUserPrincipal() {
		//return IHTASession.getUserContext().getName();
		return getCurrentUser().getName();
	}

	public Serializable getSessionData(String key) {
		//return IHTASession.getSessionData(key);
		return (Serializable) getHttpSession().getAttribute(key);
	}

	public void setSessionData(String key, Serializable value) {
		//IHTASession.setSessionData(key, value);
		getHttpSession().setAttribute(key,value);
	}

	public Lookup getByCode(Class<? extends Lookup> terminologyType, String code)
			throws TerminologyException {
		return terminologyCache.getTermByCode(terminologyType, code);
	}

	public <T extends Lookup> List<T> findAll(Class<T> terminologyType) throws TerminologyException {
		return terminologyCache.getTerms(terminologyType);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.IHTA.ui.HttpSessionProvider#getHttpSession()
	 */
	public HttpSession getHttpSession() {
		return FlexUtils.getHttpSession();
	}

	/**
	 * @return the IHTASession
	 */
/*	public IHTASession getIHTASession() {
		return IHTASession;
	}
*/
	/**
	 * @param IHTASession
	 *            the IHTASession to set
	 */
/*	public void setIHTASession(IHTASession IHTASession) {
		this.IHTASession = IHTASession;
	}
*/
	protected ControllerException handleException(String message, Throwable exception) {
		return handleException(message, exception, null, SeverityType.ERROR);
	}
	
	protected ControllerException handleException(Throwable exception, Object producer) {
		return handleException(null, exception, producer);
	}

	protected ControllerException handleException(String message, Throwable exception,
			Object producer) {
		return handleException(message, exception, producer, SeverityType.ERROR);
	}

	protected ControllerException handleException(String message, Throwable exception,
			Object producer, SeverityType severityType) {
		ControllerException cEx = null;
		if (exception != null) {
			if (exception instanceof HibernateOptimisticLockingFailureException) {
				ServiceOptimisticLockException optEx = new ServiceOptimisticLockException(
						"Optimistic lock error occured");
				optEx.setErrorType(ServiceOptimisticLockException.DATA_CHANGED_ERROR);
				cEx = new ControllerException(ServiceOptimisticLockException.DATA_CHANGED_ERROR,
						exception, ServiceOptimisticLockException.DATA_CHANGED_ERROR);
				cEx.setCallStatus(createControllerResult(optEx));
			} else if (exception instanceof ServiceOptimisticLockException) {
				ServiceOptimisticLockException optEx = (ServiceOptimisticLockException) exception;
				cEx = new ControllerException(optEx.getErrorType(), exception, optEx.getErrorType());
				cEx.setCallStatus(createControllerResult(optEx));
			}
		}
		if (cEx == null) {
			/*EntityKey<?> key = getExceptionService().processException(exception, message, producer,
					severityType, ApplicationName.CCHT);
			cEx = new ControllerException(message, exception, key != null ? key
					.getKeyValueAsString() : null);*/
			cEx = new ControllerException(message, exception, null);
		}
		logger.error(cEx);
		return cEx;
	}

	public ControllerResult createControllerResult(ServiceOptimisticLockException optEx) {
		ControllerResult cResult = new ControllerResult();
		cResult.setCallStatus(optEx.getErrorType());
		if (optEx.getEntity() != null) {
			//AbstractKeyedEntity entity = optEx.getEntity();
			//TODO customize for the entity
		}
		return cResult;
	}

	public TermType getCronExpression(Schedule schedule) {
		if (schedule != null) {
			return new TermType(schedule.getCronExpression(), schedule.getFriendlyDescription());
		}else {
			return null;
		}
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.service.AbstractComponent#afterPropertiesSet()
	 */
	@Override
	public void afterPropertiesSet() throws Exception {
		super.afterPropertiesSet();
		Validate.notNull(exceptionService, "exceptionService must not be null");
		Validate.notNull(terminologyCache, "terminologyCache must not be null");
		Validate.notNull(inventoryService, "inventoryService must not be null");
		Validate.notNull(securityService, "inventoryService must not be null");		
		//Validate.notNull(IHTASession, "IHTASession must not be null");
		//IHTASession.setHttpSessionProvider(this);
	}
	
	public UserPrincipal getCurrentUser() {
		SecurityContext securityContext = SecurityContextHelper.getSecurityContext();
		return securityContext.getUserPrincipal();
	}

	public ExceptionService getExceptionService() {
		return exceptionService;
	}

	public void setExceptionService(ExceptionService exceptionService) {
		this.exceptionService = exceptionService;
	}

	public TerminologyCache getTerminologyCache() {
		return terminologyCache;
	}

	public void setTerminologyCache(TerminologyCache terminologyCache) {
		this.terminologyCache = terminologyCache;
	}

	public InventoryService getInventoryService() {
		return inventoryService;
	}

	public void setInventoryService(InventoryService inventoryService) {
		this.inventoryService = inventoryService;
	}

	public RegistrationService getRegistrationService() {
		return registrationService;
	}

	public void setRegistrationService(RegistrationService registrationService) {
		this.registrationService = registrationService;
	}

	public SecurityService getSecurityService() {
		return securityService;
	}

	public void setSecurityService(SecurityService securityService) {
		this.securityService = securityService;
	}

	public QIRService getQirService() {
		return qirService;
	}

	public void setQirService(QIRService qirService) {
		this.qirService = qirService;
	}

	public DMPService getDmpService() {
		return dmpService;
	}

	public void setDmpService(DMPService dmpService) {
		this.dmpService = dmpService;
	}
}
