package gov.va.med.ccht.portlet;

import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserPrincipal;

import java.io.IOException;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;


public class CchtPortlet extends GenericPortlet {

	public void doView(RenderRequest request, RenderResponse response)
			throws PortletException, IOException {

		SecurityContext securityContext = SecurityContextHelper
				.getSecurityContext();
		UserPrincipal user = (securityContext != null) ? securityContext
				.getUserPrincipal() : null;
		if (user != null) {
			String userName = user.getName();

			//System.out.println("LOGIN_USER = " + user.getName());
			if (userName != null && userName.length() > 0) {
				// String initialWindowState =
				// getInitParameter(INITIAL_WINDOW_STATE);
				String cchtBridge = getInitParameter("cchtBridge");
				if (cchtBridge != null && cchtBridge.length() > 0) {
					request.setAttribute("webContext",
							getInitParameter("webContext"));
					request.setAttribute("wrapper",
							getInitParameter("wrapper"));

					PortletRequestDispatcher prd = getPortletContext()
							.getRequestDispatcher(cchtBridge);
					prd.include(request, response);
				}
			}
		} else {
			//System.out.println("User Not found");
		}
	}

	public void processAction(ActionRequest request, ActionResponse response)
			throws PortletException, PortletSecurityException, IOException {
	}
}