package gov.va.med.ccht.controller;

import gov.va.med.ccht.model.dmp.PatientSatSurveyReportParameters;
import gov.va.med.ccht.model.dmpreport.PSSQuestionManager;
import gov.va.med.ccht.model.dmpreport.VendorSubmissionReportEntry;
import gov.va.med.ccht.service.dmpreport.VendorSubmissionReportService;
import gov.va.med.ccht.ui.common.AbstractController;
import gov.va.med.ccht.ui.common.ControllerException;

import java.util.List;

public class VendorSubmissionReportController extends AbstractController 
{
	VendorSubmissionReportService vendorSubmissionReportService;

	public VendorSubmissionReportService getVendorSubmissionReportService() 
	{
		return vendorSubmissionReportService;
	}

	public void setVendorSubmissionReportService(VendorSubmissionReportService vendorSubmissionReportService) 
	{
		this.vendorSubmissionReportService = vendorSubmissionReportService;
	}
		
	public List<VendorSubmissionReportEntry> getVendorSubmissionReport(PatientSatSurveyReportParameters reportParams)  throws ControllerException
	{
		try
		{
			return getVendorSubmissionReportService().findVendorSubmissionReport(reportParams);
		}
		catch(Exception e)
		{			
			throw handleException(e.getMessage(), e);
		}
	}
	

	public PSSQuestionManager getQuestionsForReportVersion(Integer version)  throws ControllerException
	{
		try
		{
			return getVendorSubmissionReportService().getQuestionsForReportVersion(version);
		}
		catch(Exception e)
		{			
			throw handleException(e.getMessage(), e);
		}		
	}	
	
		
}
