package gov.va.med.ccht.controller;

import gov.va.med.ccht.model.dmp.PatientSatSurveyReportParameters;
import gov.va.med.ccht.model.dmpreport.PSSQuestionManager;
import gov.va.med.ccht.model.dmpreport.VRTwelveReportResults;
import gov.va.med.ccht.service.dmpreport.VRTwelveReportService;
import gov.va.med.ccht.ui.common.AbstractController;
import gov.va.med.ccht.ui.common.ControllerException;

import java.util.List;

public class VRTwelveReportController extends AbstractController 
{
	private VRTwelveReportService vrTwelveReportService;

	public VRTwelveReportService getVrTwelveReportService() 
	{
		return vrTwelveReportService;
	}

	public void setVrTwelveReportService(VRTwelveReportService vrTwelveReportService) 
	{
		this.vrTwelveReportService = vrTwelveReportService;
	}
	
	public List<VRTwelveReportResults> getVRTwelveReport(PatientSatSurveyReportParameters reportParams)  throws ControllerException
	{
		try
		{
			return getVrTwelveReportService().findVRTwelveReport(reportParams);
		}
		catch(Exception e)
		{			
			throw handleException(e.getMessage(), e);
		}		
	}	
	
	
	public PSSQuestionManager getQuestionsForReportVersion(Integer version)  throws ControllerException
	{
		try
		{
			return getVrTwelveReportService().getQuestionsForReportVersion(version);
		}
		catch(Exception e)
		{			
			throw handleException(e.getMessage(), e);
		}		
	}	
	
}
