package gov.va.med.ccht.controller;

import java.util.List;

import gov.va.med.ccht.model.dmp.PatientSatSurveyReportParameters;
import gov.va.med.ccht.model.dmpreport.PSSQuestionManager;
import gov.va.med.ccht.model.dmpreport.SurveyDistributionEntry;
import gov.va.med.ccht.model.dmpreport.SurveyDistributionSearchResult;
import gov.va.med.ccht.service.dmpreport.SurveyDistributionReportService;
import gov.va.med.ccht.ui.common.AbstractController;
import gov.va.med.ccht.ui.common.ControllerException;

public class SurveyDistributionReportController extends AbstractController 
{
	private SurveyDistributionReportService surveyDistributionReportService;

	public SurveyDistributionReportService getSurveyDistributionReportService() 
	{
		return surveyDistributionReportService;
	}

	public void setSurveyDistributionReportService(SurveyDistributionReportService surveyDistributionReportService) 
	{
		this.surveyDistributionReportService = surveyDistributionReportService;
	}
	
	
	public SurveyDistributionSearchResult getSurveyReports(PatientSatSurveyReportParameters reportParams)  throws ControllerException
	{
		try
		{
			return getSurveyDistributionReportService().findSurveyDistributionReport(reportParams);
		}
		catch(Exception e)
		{			
			throw handleException(e.getMessage(), e);
		}
	}
	
	public PSSQuestionManager getQuestionsForReportVersion(Integer version)  throws ControllerException
	{
		try
		{
			return getSurveyDistributionReportService().getQuestionsForReportVersion(version);
		}
		catch(Exception e)
		{			
			throw handleException(e.getMessage(), e);
		}		
	}	
	
}
