package gov.va.med.ccht.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import gov.va.med.fw.ui.conversion.ConversionServiceException;
import gov.va.med.fw.ui.model.TermType;

import gov.va.med.ccht.model.AppUserGroup;
import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.UserPreference;
import gov.va.med.ccht.model.UserRole;
import gov.va.med.ccht.model.terminology.InactiveReason;
import gov.va.med.ccht.model.terminology.RegistrationDeniedReason;
import gov.va.med.ccht.model.terminology.RegistrationReason;
import gov.va.med.ccht.model.terminology.RegistrationStatus;
import gov.va.med.ccht.service.common.TerminologyException;

import gov.va.med.ccht.ui.common.AbstractConversionService;
import gov.va.med.ccht.ui.model.UserForm;

public final class SecurityConversionService extends AbstractConversionService {

	public void convert(User user, UserForm userForm) throws ConversionServiceException {
		userForm.setId(user.getId() == null ? null : String.valueOf(user.getId()));
		userForm.setUserName(user.getUsername());
		userForm.setGivenName(user.getGivenName());
		userForm.setMiddleName(user.getMiddleName());
		userForm.setFamilyName(user.getFamilyName());
		userForm.setTitle(user.getTitle());
		userForm.setDepartment(user.getDepartment());
		userForm.setDescription(user.getDescription());
		userForm.setOffice(user.getOffice());
		userForm.setTelephoneNumber(user.getTelephoneNumber());
		userForm.setEmail(user.getEmail());
		
		userForm.setRegistrationStatus(toTermType(user.getRegistrationStatus()));
		userForm.setRegistrationDeniedReason(toTermType(user.getRegistrationDeniedReason()));
		userForm.setVisn(toTermType(user.getVisn()));
		userForm.setFacility(toTermType(user.getFacility()));
		userForm.setVendor(toTermType(user.getVendor()));
		userForm.setSecondaryFacility(toTermType(user.getSecondaryFacility()));
		userForm.setRegistrationReason(toTermType(user.getRegistrationReason()));
		
		userForm.setAccountExpireDate(user.getAccountExpireDate());
		//Lock
		userForm.setLocked(user.isAccountLocked());
		userForm.setAccountLockDate(user.getAccountLockDate());
		//Inactive
		userForm.setInactive(user.isInactive());
		userForm.setInactiveReason(toTermType(user.getInactiveReason()));
		userForm.setInactiveDate(user.getInactiveDate());
		
		userForm.setLoginFailedDate(user.getLoginFailedDate());
		userForm.setLoginFailedCount(user.getLoginFailedCount());		
		
		//Roles
		List<TermType> assignedRoles = new ArrayList<TermType>();
		for (UserRole userRole:user.getRoles()) {
			assignedRoles.add(new TermType(userRole.getRole().getName(), userRole.getRole().getName()));
		}
		userForm.setRoles(assignedRoles);
		
		//Only one group is supported
		TermType userGroup = null;		
		for (AppUserGroup appUserGroup:user.getUserGroups()) {
			userGroup = new TermType(appUserGroup.getUserGroup().getName(), appUserGroup.getUserGroup().getCode());
			userForm.setUserGroup(userGroup);
			break;
		}
		
		// User Preferences
		String value = user.getPreferenceValue(UserPreference.MULTIPLE_WINDOWS);
		userForm.setMultipleWindows( value != null ? Boolean.valueOf( value ) : null );
		userForm.setMultipleWindows( value != null ? Boolean.valueOf( value ) : null );
	}

	public void convert(UserForm userForm,  User user) throws ConversionServiceException {	
		try {
			user.setGivenName(userForm.getGivenName());
			user.setMiddleName(userForm.getMiddleName());
			user.setFamilyName(userForm.getFamilyName());
			user.setTitle(userForm.getTitle());
			user.setDepartment(userForm.getDepartment());
			user.setDescription(userForm.getDescription());
			user.setOffice(userForm.getOffice());
			user.setTelephoneNumber(userForm.getTelephoneNumber());
			user.setEmail(userForm.getEmail());
		
			user.setRegistrationStatus(getLookup(RegistrationStatus.class,userForm.getRegistrationStatus()));
			user.setRegistrationDeniedReason(getLookup(RegistrationDeniedReason.class,userForm.getRegistrationDeniedReason()));
			user.setVisn(getVisn(userForm.getVisn()));
			user.setFacility(getFacility(userForm.getFacility()));
			user.setSecondaryFacility(getFacility(userForm.getSecondaryFacility()));
			if (user.getFacility() != null) {
				user.setVisn(user.getFacility().getVisn());
			}
			user.setVendor(getVendor(userForm.getVendor()));
			user.setRegistrationReason(getLookup(RegistrationReason.class, userForm.getRegistrationReason()));			
			user.setAccountExpireDate(userForm.getAccountExpireDate());
			
			if (userForm.getLocked() != null && userForm.getLocked()) {
				if (user.getAccountLockDate() == null) {
					user.setAccountLockDate(new Date());
				}
			}else {
				user.setAccountLockDate(null);
				user.setLoginFailedCount(0);
			}

			if (userForm.getInactive() != null && userForm.getInactive()) {
				user.setInactiveDate(userForm.getInactiveDate());
				user.setInactiveReason(getLookup(InactiveReason.class, userForm.getInactiveReason()));
			}else {
				user.setInactiveDate(null);
				user.setInactiveReason(null);
			}
						
			//user.setLoginFailedDate(userForm.getLoginFailedDate());
			
			//roles
			List<TermType> newRoles = userForm.getRoles();
			List<UserRole> deletedRoles = new ArrayList<UserRole>();
			//Retain the roles
			for (UserRole userRole:user.getRoles()) {
				TermType oldRole = new TermType(userRole.getRole().getName(), userRole.getRole().getName());
				if (newRoles.remove(oldRole)) {
					//nothing to do
				}else {
					deletedRoles.add(userRole);
				}
			}
			//delete roles
			for (UserRole userRole:deletedRoles) {
				user.removeRole(userRole);
			}
			//add roles
			for (TermType newRole:newRoles) {
				UserRole userRole = new UserRole();
				userRole.setRole(getRole(newRole));
				user.addRole(userRole);
			}
			
			//group - read only no update
			//address - no update not yet supported
			
			// User Preferences
			user.addOrUpdatePreference(UserPreference.MULTIPLE_WINDOWS,String.valueOf(userForm.getMultipleWindows()));
			
		}catch (TerminologyException e){
			throw new ConversionServiceException("UserForm to User conversion failed ",e);
		}
	}
}
