package gov.va.med.ccht.controller;

import gov.va.med.ccht.model.dmp.PatientSatSurveyReportParameters;
import gov.va.med.ccht.model.dmpreport.PSSQuestionManager;
import gov.va.med.ccht.model.dmpreport.SatisfactionSurveyTrendEntry;
import gov.va.med.ccht.service.dmpreport.SatisfactionSurveyTrendService;
import gov.va.med.ccht.ui.common.AbstractController;
import gov.va.med.ccht.ui.common.ControllerException;

import java.util.List;

public class SatisfactionSurveyTrendReportController extends AbstractController 
{
	private SatisfactionSurveyTrendService satisfactionSurveyTrendService;

	public SatisfactionSurveyTrendService getSatisfactionSurveyTrendService() 
	{
		return satisfactionSurveyTrendService;
	}

	public void setSatisfactionSurveyTrendService(SatisfactionSurveyTrendService satisfactionSurveyTrendService) 
	{
		this.satisfactionSurveyTrendService = satisfactionSurveyTrendService;
	}
	
	public List<SatisfactionSurveyTrendEntry> getSatisfactionSurveyTrendReport(PatientSatSurveyReportParameters reportParams)  throws ControllerException
	{
		try
		{
			return getSatisfactionSurveyTrendService().findSatisfactionSurveyTrendReport(reportParams);
		}
		catch(Exception e)
		{			
			throw handleException(e.getMessage(), e);
		}
	}
	
	public PSSQuestionManager getQuestionsForReportVersion(Integer version)  throws ControllerException
	{
		try
		{
			return getSatisfactionSurveyTrendService().getQuestionsForReportVersion(version);
		}
		catch(Exception e)
		{			
			throw handleException(e.getMessage(), e);
		}		
	}	
}
