package gov.va.med.ccht.controller;


import gov.va.med.ccht.model.dmp.PatientSatSurveyReportParameters;
import gov.va.med.ccht.model.dmpreport.PSSQuestionManager;
import gov.va.med.ccht.model.dmpreport.SatisfactionSurveyQuestion;
import gov.va.med.ccht.model.dmpreport.SatisfactionSurveyQuestionResult;
import gov.va.med.ccht.service.dmpreport.SatisfactionSurveyResultService;
import gov.va.med.ccht.ui.common.AbstractController;
import gov.va.med.ccht.ui.common.ControllerException;

import java.util.List;

public class SatisfactionSurveyReportController extends AbstractController 
{
	private SatisfactionSurveyResultService satisfactionSurveyResultService;
	
	public SatisfactionSurveyResultService getSatisfactionSurveyResultService() {
		return satisfactionSurveyResultService;
	}
	public void setSatisfactionSurveyResultService(SatisfactionSurveyResultService satisfactionSurveyResultService) {
		this.satisfactionSurveyResultService = satisfactionSurveyResultService;
	}
	
	public List<SatisfactionSurveyQuestionResult>  getSatisfactionSurveyReport(PatientSatSurveyReportParameters reportParams)  throws ControllerException
	{
		try
		{
			return getSatisfactionSurveyResultService().findSatisfactionSurveyResultReport(reportParams);
		}
		catch(Exception e)
		{			
			throw handleException(e.getMessage(), e);
		}
	}
	
	public PSSQuestionManager getQuestionsForReportVersion(Integer version)  throws ControllerException
	{
		try
		{
			return getSatisfactionSurveyResultService().getQuestionsForReportVersion(version);
		}
		catch(Exception e)
		{			
			throw handleException(e.getMessage(), e);
		}		
	}	
	
	
}
