/**
 * 
 */
package gov.va.med.ccht.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

import edu.emory.mathcs.backport.java.util.Collections;

import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.ui.conversion.ConversionServiceException;
import gov.va.med.fw.ui.model.Form;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.date.TimeZoneUtils;
import gov.va.med.ccht.model.inventory.DeviceType;
import gov.va.med.ccht.model.qir.DmpQirType;
import gov.va.med.ccht.model.qir.QIR;
import gov.va.med.ccht.model.qir.QIRSimpleAttachment;
import gov.va.med.ccht.model.qir.QIRRemarks;
import gov.va.med.ccht.model.qir.QIRStatusType;
import gov.va.med.ccht.model.qir.QIRType;
import gov.va.med.ccht.model.qir.QIRVendorAction;
import gov.va.med.ccht.service.common.TerminologyException;
import gov.va.med.ccht.ui.common.AbstractConversionService;
import gov.va.med.ccht.ui.model.AttachmentForm;
import gov.va.med.ccht.ui.model.FormattedDateForm;
import gov.va.med.ccht.ui.model.QIRForm;


/**
 * @author vhaisakatikm
 *
 */
public class QIRConversionService extends AbstractConversionService {
	@Override
	public void convert(AbstractEntity bom, Form form)
			throws ConversionServiceException {
		try {
			if (bom instanceof QIR) {
				toQIRForm((QIR)bom, (QIRForm)form);
			}
		}catch(Exception e){
			throw new ConversionServiceException(e.getMessage(),e);
		}
	}

	@Override
	public void convert(Form form, AbstractEntity bom)
			throws ConversionServiceException {
		try {
			if (bom instanceof QIR) {
				toQIR((QIRForm)form, (QIR) bom);
			}
		}catch(Exception e){
			throw new ConversionServiceException(e.getMessage(),e);
		}
	}
	
	private void toQIRForm(QIR qir, QIRForm qirForm)  {
		qirForm.setId(String.valueOf(qir.getId()));
		qirForm.setVersionNumber(String.valueOf(qir.getVersion()));
		qirForm.setDmpQirType(toTermType(qir.getDmpQirType()));
		qirForm.setQirType(toTermType(qir.getQirType()));
		qirForm.setQirStatusType(toTermType(qir.getQirStatusType()));			
		qirForm.setVisn(toTermType(qir.getVisn()));
		qirForm.setFacility(toTermType(qir.getFacility()));			
		qirForm.setDeviceType(toTermType(qir.getDeviceType()));
		qirForm.setVendor(toTermType(qir.getVendor()));		
		qirForm.setSerialNumber(qir.getSerialNumber());
		qirForm.setPurchaseOrderNumber(qir.getPurchaseOrderNumber());
		qirForm.setSubmittedDate(qir.getSubmittedDate());
		qirForm.setVendorResponseDueDate(qir.getVendorResponseDueDate());
		qirForm.setEmailReminderSentDate(qir.getEmailReminderSentDate());
		qirForm.setStatusChangeDate(qir.getStatusChangeDate());
		qirForm.setComplaint(qir.getComplaint());
		qirForm.setHeadline(qir.getHeadline());
		qirForm.setSubmittedBy(qir.getSubmittedBy());
		qirForm.setSubmittedByName(qir.getSubmittedByName());
		qirForm.setIsDmpIssue(qir.getIsDmpIssue());
		String facilityNumAndName="";
		if(qir.getFacility()!=null)
		{
			if(StringUtils.isNotEmpty(qir.getFacility().getStationNumber()))
			{
				facilityNumAndName=qir.getFacility().getStationNumber();
			}
			if(StringUtils.isNotEmpty(qir.getFacility().getName()))
			{
				facilityNumAndName=facilityNumAndName+" "+qir.getFacility().getName();
			}
		}
		qirForm.setFacilityNumAndName(facilityNumAndName);
		
		//Remarks
		String remarksHistory = "";
		List<QIRRemarks> remarksList = new ArrayList<QIRRemarks>(qir.getRemarks());
		Collections.sort(remarksList, Collections.reverseOrder());
		for (QIRRemarks remarks:remarksList) {
			
			qirForm.setRemarks(remarks.getRemarks());						
			
			remarksHistory = remarksHistory + 
			TimeZoneUtils.convertDateToTimeZone(remarks.getDate(), TimeZone.getDefault()) + ", " + remarks.getSubmittedByName()+ ": " + remarks.getRemarks() + "\n";
		}
		qirForm.setRemarksHistory(remarksHistory);
		
		//Vendor Actions
		String vendorActionsHistory = "";
		List<QIRVendorAction> vendorActionsList = new ArrayList<QIRVendorAction>(qir.getVendorActions());
		Collections.sort(vendorActionsList, Collections.reverseOrder());
		for (QIRVendorAction vendorActions:vendorActionsList) {
			
			if(qirForm.getLastRepliedDate() == null)
			{
				qirForm.setLastRepliedDate(vendorActions.getDate());
			}
			else if(vendorActions.getDate().after(qirForm.getLastRepliedDate()))
			{
				qirForm.setLastRepliedDate(vendorActions.getDate());
			}
			
			vendorActionsHistory = vendorActionsHistory + 
			TimeZoneUtils.convertDateToTimeZone(vendorActions.getDate(), TimeZone.getDefault()) + ", " + vendorActions.getSubmittedByName()+ ": " + vendorActions.getAction() + "\n";
		}
		qirForm.setVendorActionsHistory(vendorActionsHistory);
		
		//Attachments
		List<AttachmentForm> attachments = new ArrayList<AttachmentForm>();
		for (QIRSimpleAttachment attachment:qir.getAttachments()) {
			AttachmentForm attachmentForm = new AttachmentForm();
			attachmentForm.setId(String.valueOf(attachment.getId()));
			attachmentForm.setDate(attachment.getDate());
			attachmentForm.setName(attachment.getDocumentName());
			attachmentForm.setType(toTermType(attachment.getDocumentType()));
			attachmentForm.setModifiedBy(attachment.getCreatedBy().getChangeUser());
			attachmentForm.setLength(attachment.getLength());
			attachments.add(attachmentForm);
		}
		qirForm.setAttachments(attachments);
	}
	
	private void toQIR(QIRForm qirForm, QIR qir) throws TerminologyException {
		
		if (qir.getId() == null) {
			//copy read only properties 			
		}
		
		qir.setQirType(getLookup(QIRType.class,qirForm.getQirType()));
		qir.setQirStatusType(getLookup(QIRStatusType.class,qirForm.getQirStatusType()));			
		qir.setVisn(getVisn(qirForm.getVisn()));
		qir.setFacility(getFacility(qirForm.getFacility()));			
		qir.setDeviceType(getLookup(DeviceType.class,qirForm.getDeviceType()));
		if (qir.getDeviceType() != null) {
			qir.setVendor(qir.getDeviceType().getVendor());					
		}else {
			qir.setVendor(getVendor(qirForm.getVendor()));
		}
		qir.setSerialNumber(qirForm.getSerialNumber());
		qir.setPurchaseOrderNumber(qirForm.getPurchaseOrderNumber());
		qir.setSubmittedDate(qirForm.getSubmittedDate());
		qir.setVendorResponseDueDate(qirForm.getVendorResponseDueDate());
		qir.setEmailReminderSentDate(qirForm.getEmailReminderSentDate());
		qir.setStatusChangeDate(qirForm.getStatusChangeDate());
		qir.setComplaint(qirForm.getComplaint());
		qir.setHeadline(qirForm.getHeadline());
		qir.setSubmittedBy(qirForm.getSubmittedBy());
		qir.setIsDmpIssue(qirForm.getIsDmpIssue());
		qir.setDmpQirType(getLookup(DmpQirType.class, qirForm.getDmpQirType()));
		//copy editable properties
		if (StringUtils.isNotEmpty(qirForm.getRemarks())) {
			QIRRemarks remarks = new QIRRemarks();
			remarks.setDate(new Date());
			remarks.setRemarks(qirForm.getRemarks());
			qir.addRemarks(remarks);
		}
		if (StringUtils.isNotEmpty(qirForm.getVendorActions())) {
			QIRVendorAction actions = new QIRVendorAction();
			actions.setDate(new Date());
			actions.setAction(qirForm.getVendorActions());
			qir.addVendorActions(actions);
		}
		//Attachments handled separately
	}	
}
