package gov.va.med.ccht.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

import edu.emory.mathcs.backport.java.util.Collections;

import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.ui.conversion.ConversionServiceException;
import gov.va.med.fw.ui.model.Form;

import gov.va.med.ccht.model.inventory.DeviceDetail;
import gov.va.med.ccht.model.inventory.DeviceRequirement;
import gov.va.med.ccht.model.inventory.DeviceStatus;
import gov.va.med.ccht.model.inventory.DeviceStatusHistory;
import gov.va.med.ccht.model.inventory.DeviceStatusType;
import gov.va.med.ccht.model.inventory.DeviceType;

import gov.va.med.ccht.service.common.TerminologyException;
import gov.va.med.ccht.ui.common.AbstractConversionService;
import gov.va.med.ccht.ui.model.DeviceDetailForm;
import gov.va.med.ccht.ui.model.DeviceRequirementForm;
import gov.va.med.ccht.ui.model.DeviceStatusForm;

public class InventoryConversionService extends AbstractConversionService {

	@Override
	public void convert(AbstractEntity bom, Form form)
			throws ConversionServiceException {
		try {
			if (bom instanceof DeviceDetail) {
				toDeviceDetailForm((DeviceDetail)bom, (DeviceDetailForm)form);
			}else if (bom instanceof DeviceRequirement) {
				toDeviceRequirementForm((DeviceRequirement) bom, (DeviceRequirementForm) form);
			}
		}catch(Exception e){
			throw new ConversionServiceException(e.getMessage(),e);
		}
	}

	@Override
	public void convert(Form form, AbstractEntity bom)
			throws ConversionServiceException {
		try {
			if (bom instanceof DeviceDetail) {
				toDeviceDetail((DeviceDetailForm)form, (DeviceDetail) bom);
			}else if (bom instanceof DeviceRequirement) {
				toDeviceRequirement((DeviceRequirementForm) form, (DeviceRequirement) bom);
			}
		}catch(Exception e){
			throw new ConversionServiceException(e.getMessage(),e);
		}
	}

	private void toDeviceDetail(DeviceDetailForm form, DeviceDetail deviceDetail)
	throws TerminologyException {
		//New device - set serial number, device type and facility
		if (deviceDetail.getId() == null) {
			deviceDetail.setSerialNumber(form.getSerialNumber());
			deviceDetail.setFacility(getFacility(form.getFacility()));
			//deviceDetail.setDeviceDecommissionReason(getLookup(DeviceDecommissionReason.class,form.getDeviceDecommissionReason()));
			deviceDetail.setDeviceType(getLookup(DeviceType.class,form.getDeviceType()));
		}
		
		deviceDetail.setEeNumber(form.getEeNumber());
		deviceDetail.setPurchaseOrderNumber(form.getPurchaseOrderNumber());
		deviceDetail.setDateOfPurchase(form.getDateOfPurchase());
		deviceDetail.setWarrantyFromDate(form.getWarrantyFromDate());
		deviceDetail.setWarrantyToDate(form.getWarrantyToDate());
		//deviceDetail.setMultiPatientUsage(form.getMultiPatientUsage());
		//deviceDetail.setLastActiveDate(form.getLastActiveDate());
		DeviceStatus ds = deviceDetail.getDeviceStatus();
		if (ds == null) ds = new DeviceStatus();
		DeviceStatusForm dsForm = form.getDeviceStatus();
		if (dsForm != null) {		
			ds.setDeviceStatusType(getLookup(DeviceStatusType.class, dsForm.getDeviceStatusType()));
			ds.setStatusChangeDate(dsForm.getStatusChangeDate());
			deviceDetail.setDeviceStatus(ds);
		}
	}
	
	private void toDeviceRequirement(DeviceRequirementForm form,  DeviceRequirement deviceRequirement) throws TerminologyException {
		if (!deviceRequirement.getDevicesNeeded().equals(form.getDevicesNeeded())){
			deviceRequirement.setDevicesNeeded(form.getDevicesNeeded());
			deviceRequirement.setAssessmentDate(new Date()); //set to today's date				
		}
		if (deviceRequirement.getFacility() == null) {
			deviceRequirement.setFacility(getFacility(form.getFacility()));		
		}
		if (deviceRequirement.getDeviceType() == null) {
			deviceRequirement.setDeviceType(getLookup(DeviceType.class,form.getDeviceType()));
		}
	}
	
	private void toDeviceDetailForm(DeviceDetail deviceDetail, DeviceDetailForm form)
	 {
		form.setId(String.valueOf(deviceDetail.getId()));
		form.setVersionNumber(String.valueOf(deviceDetail.getVersion()));
		form.setSerialNumber(deviceDetail.getSerialNumber());
		form.setFacility(toTermType(deviceDetail.getFacility()));
		form.setDeviceDecommissionReason(toTermType(deviceDetail.getDeviceDecommissionReason()));
		form.setDeviceType(toTermType(deviceDetail.getDeviceType()));
		form.setEeNumber(deviceDetail.getEeNumber());
		form.setPurchaseOrderNumber(deviceDetail.getPurchaseOrderNumber());
		form.setDateOfPurchase(deviceDetail.getDateOfPurchase());
		form.setWarrantyFromDate(deviceDetail.getWarrantyFromDate());
		form.setWarrantyToDate(deviceDetail.getWarrantyToDate());
		form.setMultiPatientUsage(deviceDetail.getMultiPatientUsage());
		form.setLastActiveDate(deviceDetail.getLastActiveDate());
		DeviceStatus ds = deviceDetail.getDeviceStatus();
		if (ds != null) {
			DeviceStatusForm dsForm = new DeviceStatusForm();
			dsForm.setDeviceStatusType(toTermType(ds.getDeviceStatusType()));
			dsForm.setStatusChangeDate(ds.getStatusChangeDate());
			form.setDeviceStatus(dsForm);
		}
		Set<DeviceStatusHistory> dsSet = deviceDetail.getDeviceStatusHistory();
		List<DeviceStatusForm> dsFormList = new ArrayList<DeviceStatusForm>();
		if (dsSet != null) {
			for (DeviceStatusHistory dsHistory:dsSet) {
				DeviceStatusForm dsForm = new DeviceStatusForm();
				dsForm.setDeviceStatusType(toTermType(dsHistory.getDeviceStatusType()));
				dsForm.setStatusChangeDate(dsHistory.getStatusChangeDate());
				dsFormList.add(dsForm);
			}
			Collections.sort(dsFormList);
		}
		form.setDeviceStatusHistory(dsFormList);
	}
	
	private void toDeviceRequirementForm(DeviceRequirement deviceRequirement, DeviceRequirementForm form) {
		form.setId(deviceRequirement.getId() == null ? null : String.valueOf(deviceRequirement.getId()));
		form.setVersionNumber(deviceRequirement.getVersion() == null ? null : String.valueOf(deviceRequirement.getVersion()));
		form.setFacility(toTermType(deviceRequirement.getFacility()));
		form.setDeviceType(toTermType(deviceRequirement.getDeviceType()));
		form.setDevicesNeeded(deviceRequirement.getDevicesNeeded());
		form.setDevicesOnHand(deviceRequirement.getDevicesOnHand());
		form.setAssessmentDate(deviceRequirement.getAssessmentDate());
	}
}
