package gov.va.med.ccht.controller;

import gov.va.med.ccht.model.inventory.DIReportData;
import gov.va.med.ccht.model.inventory.DIReportParameters;
import gov.va.med.ccht.model.inventory.Device;
import gov.va.med.ccht.model.inventory.DeviceDetail;
import gov.va.med.ccht.model.inventory.DeviceRequirement;
import gov.va.med.ccht.model.inventory.DeviceSearchParameters;
import gov.va.med.ccht.model.inventory.DeviceSearchResult;
import gov.va.med.ccht.model.inventory.Facility;
import gov.va.med.ccht.model.inventory.ReportWeek;
import gov.va.med.ccht.model.inventory.SimpleFacility;
import gov.va.med.ccht.model.inventory.VCReportData;
import gov.va.med.ccht.model.inventory.Vendor;
import gov.va.med.ccht.model.inventory.Visn;
import gov.va.med.ccht.service.report.ReportConstants;
import gov.va.med.ccht.ui.common.AbstractController;
import gov.va.med.ccht.ui.common.ControllerException;
import gov.va.med.ccht.ui.common.ControllerResult;
import gov.va.med.ccht.ui.model.DIReportParameterForm;
import gov.va.med.ccht.ui.model.DeviceDetailForm;
import gov.va.med.ccht.ui.model.DeviceRequirementForm;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.service.ServiceOptimisticLockException;
import gov.va.med.fw.ui.model.TermType;
import gov.va.med.fw.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class InventoryController extends AbstractController implements ReportConstants{

	public List<DIReportData> searchDeviceBySerialNumber(DeviceSearchParameters deviceSearchParameters)
	throws ControllerException {
		try {
			List<Object[]> data = getInventoryService().searchDevice(deviceSearchParameters);
			List<DIReportData> results = new ArrayList<DIReportData>();
			String searchType = deviceSearchParameters.getSearchType().getValue();
			if (DeviceSearchParameters.DEVICE_SEARCH_TYPE_SERIAL_NUMBER.equals(searchType)){
				for (Object[] objs:data){
					DIReportData record = new DIReportData();
					record.deviceSerialNumber = (String)objs[0];
					record.facilityName = (String)objs[1];					
					record.vendorName = (String)objs[2];
					record.deviceCount = (Integer) objs[3];
					results.add(record);
				}					
			}
			else {
				throw new Exception("Invalid Device search type" + searchType);
			}
			return results;		
		}catch (Exception e){
			throw new ControllerException(e.getMessage(),e);
		}
	}
	
	public List<DeviceSearchResult> searchDevice(DeviceSearchParameters deviceSearchParameters)
	throws ControllerException {
		try {
			List<Object[]> data = getInventoryService().searchDevice(deviceSearchParameters);
			List<DeviceSearchResult> results = new ArrayList<DeviceSearchResult>();
			String searchType = deviceSearchParameters.getSearchType().getValue();
			if (DeviceSearchParameters.DEVICE_SEARCH_TYPE_PATIENT.equals(searchType)) {
				for (Object[] objs:data){
					DeviceSearchResult record = new DeviceSearchResult();
					record.vendorName = (String)objs[0];
					record.deviceName = (String)objs[1];
					record.deviceSerialNumber = (String)objs[2];
					record.activationDate = (Date)objs[3];
					record.lastName = (String)objs[4];
					record.firstName = (String)objs[5];
					record.middleName = (String)objs[6];
					record.ssn = (String)objs[7];
					record.icn = (String)objs[8];					
					results.add(record);
				}
			}else if (DeviceSearchParameters.DEVICE_SEARCH_TYPE_ACTIVATION_DATE.equals(searchType)){
				for (Object[] objs:data){
					DeviceSearchResult record = new DeviceSearchResult();
					record.vendorName = (String)objs[0];
					record.deviceName = (String)objs[1];
					record.deviceSerialNumber = (String)objs[2];
					record.activationDate = (Date)objs[3];	
					results.add(record);
				}
			}
			else if (DeviceSearchParameters.DEVICE_SEARCH_TYPE_STATUS.equals(searchType)){
				for (Object[] objs:data){
					DeviceSearchResult record = new DeviceSearchResult();
					record.vendorName = (String)objs[0];
					record.deviceName = (String)objs[1];
					record.deviceSerialNumber = (String)objs[2];
					record.deviceStatus = (String)objs[3];	
					results.add(record);
				}
			}
			else if (DeviceSearchParameters.DEVICE_SEARCH_TYPE_GENERIC.equals(searchType)){
				for (Object[] objs:data){
					DeviceSearchResult record = new DeviceSearchResult();
					record.id = String.valueOf(objs[0]);
					record.deviceName = (String)objs[1];
					record.deviceSerialNumber = (String)objs[2];
					record.multiPatientUsage = (Boolean) objs[3];	
					record.statusChangeDate = (Date) objs[4];
					record.deviceStatus = (String) objs[5];
					record.lastName = (String) objs[6];
					record.careCoordinator = (String) objs[7];
					results.add(record);
				}
			}			
			else {
				throw new Exception("Invalid Device search type" + searchType);
			}
			return results;		
		}catch (Exception e){
			throw new ControllerException(e.getMessage(),e);
		}
	}
	public DeviceDetailForm getDeviceDetail(String id) throws ControllerException {
		EntityKey<DeviceDetail> entityKey = EntityKeyFactory.createEntityKey(new Long(id), DeviceDetail.class);
		try {
			DeviceDetail dd = getInventoryService().getDeviceDetail(entityKey);
			DeviceDetailForm ddForm = new DeviceDetailForm();
			getInventoryConversionService().convert(dd, ddForm);
			return ddForm;
		}catch (Exception e){
			throw new ControllerException(e.getMessage(),e);
		}
	}
	
	public ControllerResult addDeviceDetail(DeviceDetailForm deviceDetailForm) throws ControllerException {
		try {
			//Verify whether the device with same model and serial number exists
			DeviceSearchParameters deviceSearchParameters = new DeviceSearchParameters();
			deviceSearchParameters.setDeviceType(deviceDetailForm.getDeviceType());
			deviceSearchParameters.setSerialNumber(deviceDetailForm.getSerialNumber());
			DeviceDetail dd = getInventoryService().getDeviceDetail(deviceSearchParameters);
			if (dd == null) {
				dd = new DeviceDetail();
				getInventoryConversionService().convert(deviceDetailForm, dd);
				getInventoryService().updateDeviceDetail(dd);
				return new ControllerResult(ControllerResult.SUCCESS);
			}else {
				return new ControllerResult(ControllerResult.ALREADY_EXISTS);
			}
		}
		catch (Exception e){
			throw new ControllerException(e.getMessage(),e);
		}
	}
	
	public DeviceDetailForm updateDeviceDetail(DeviceDetailForm deviceDetailForm) throws ControllerException {
		try {
			//update an existing device
			EntityKey<DeviceDetail> entityKey = 
				EntityKeyFactory.createEntityKey(new Long(deviceDetailForm.getId()), 
					new Integer(deviceDetailForm.getVersionNumber()), DeviceDetail.class);			
			DeviceDetail dd = getInventoryService().getDeviceDetail(entityKey);
			getInventoryConversionService().convert(deviceDetailForm, dd);
			getInventoryService().updateDeviceDetail(dd);
			dd = getInventoryService().getDeviceDetail(entityKey);
			DeviceDetailForm ddForm = new DeviceDetailForm();
			getInventoryConversionService().convert(dd, ddForm);
			return ddForm;
		}catch (ServiceOptimisticLockException ople){
			throw new ControllerException("Database operation failed because data was changed by another session. You will have to re-load it and re-apply your changes.");	
		}catch (Exception e){
			throw new ControllerException(e.getMessage(),e);
		}
	}
	
	public List<DIReportData> generateVCCurrentReport(DeviceSearchParameters deviceSearchParameters)
	throws ControllerException {
		try {
			List<Object[]> data = getInventoryService().generateVCCurrentReport(deviceSearchParameters);
			List<DIReportData> results = new ArrayList<DIReportData>();
			for (Object[] objs:data){
				DIReportData record = new DIReportData();
				record.vendorName = (String)objs[0];
				record.deviceName = (String)objs[1];
				record.deviceCount = (Integer)objs[2];
				record.deviceCountNoSerialNumber = (Integer)objs[3];					
				results.add(record);
			}
			return results;
		}catch (Exception e){
			throw new ControllerException(e.getMessage(),e);
		}
	}
	
	public List<VCReportData> generateVCHistoryReport(DeviceSearchParameters deviceSearchParameters)
	throws ControllerException {
		try {
			List<Object[]> data = getInventoryService().generateVCHistoryReport(deviceSearchParameters);
			List<VCReportData> results = new ArrayList<VCReportData>();
			for (Object[] objs:data){
				VCReportData record = new VCReportData();
				record.reportEndDate = (Date)objs[0];
				record.vendorName = (String)objs[1];
				record.deviceCount = (Integer)objs[2];
				record.modelNameCount = (Integer)objs[3];				
				record.serialNumberCount = (Integer)objs[4];					
				results.add(record);
			}
			return results;
		}catch (Exception e){
			throw new ControllerException(e.getMessage(),e);
		}
	}	
	
	public List<VCReportData> generateVCReportCharts(DeviceSearchParameters deviceSearchParameters) throws ControllerException {
		return generateVCHistoryReport(deviceSearchParameters);
	}
	
	public void saveInventoryReport(DIReportParameterForm dIReportParameterForm)
	throws ControllerException {
		try {
			DIReportParameters repParameters = new DIReportParameters();
			repParameters.setReportSummaryType(dIReportParameterForm.getReportSummaryType().getValue());
			repParameters.setSubTotalType(dIReportParameterForm.getSubTotalType().getValue());
			repParameters.setReportWeek(dIReportParameterForm.getReportWeek());
			if (dIReportParameterForm.getVisn() != null) {
				repParameters.setVisn(
					getInventoryService().getSimpleVisn(dIReportParameterForm.getVisn().getValue()));
			}
			if (dIReportParameterForm.getFacility() != null) {
				repParameters.setFacility(
				getInventoryService().getFacility(dIReportParameterForm.getFacility().getValue()));
			}
			//save
		}catch (Exception e){
			throw new ControllerException(e.getMessage(),e);
		}
	}
	
	public DeviceRequirementForm getDeviceRequirement(String id) throws ControllerException {
		EntityKey<DeviceRequirement> entityKey = 
			EntityKeyFactory.createEntityKey(new Long(id), DeviceRequirement.class);
		try {
			DeviceRequirement dr = getInventoryService().getDeviceRequirement(entityKey);
			DeviceRequirementForm drform = new DeviceRequirementForm();
			getInventoryConversionService().convert(dr, drform);
			return drform;
		}catch (Exception e){
			throw new ControllerException(e.getMessage(),e);
		}
	}
	
	public List<DeviceRequirementForm> getDeviceRequirements(TermType facility) 
	throws ControllerException {
		try {
			SimpleFacility simpleFacility = 
				getInventoryService().getSimpleFacility(facility.getValue());
			List<DeviceRequirementForm> list = new ArrayList<DeviceRequirementForm>();
			List<DeviceRequirement> drs = getInventoryService().getDeviceRequirements(simpleFacility);
			
			for (DeviceRequirement dr:drs) {
				DeviceRequirementForm drform = new DeviceRequirementForm();				
				getInventoryConversionService().convert(dr, drform);
				list.add(drform);
			}
			return list;
		}catch (Exception e){
			throw new ControllerException(e.getMessage(),e);
		}
	}
	
	public List<DeviceRequirementForm> updateDeviceRequirements(List<DeviceRequirementForm> deviceRequirementForms) 
	throws ControllerException {		
		try {
			TermType facility = null;
			List<DeviceRequirement> deviceRequirements = new ArrayList<DeviceRequirement>();
			
			for (DeviceRequirementForm df:deviceRequirementForms) {	
				DeviceRequirement dr = null;
				facility = df.getFacility();
				
				if (StringUtils.isNotEmpty(df.getId())) {
					EntityKey<DeviceRequirement> entityKey = 					
						EntityKeyFactory.createEntityKey(new Long(df.getId()), 
							new Integer(df.getVersionNumber()), DeviceRequirement.class);				
					//retrieve
					dr = getInventoryService().getDeviceRequirement(entityKey);
				}else {
					dr = new DeviceRequirement();
				}
				//conversion and merge update only if the value has been changed
				if (!df.getDevicesNeeded().equals(dr.getDevicesNeeded())) {
					getInventoryConversionService().convert(df, dr);
					deviceRequirements.add(dr);
				}
			}	
			//save
			if (deviceRequirements.size() > 0) {
				getInventoryService().updateDeviceRequirements(deviceRequirements);
			}
			if (facility != null) {
				return getDeviceRequirements(facility);
			}else {
				return new ArrayList<DeviceRequirementForm>();
			}
		}catch (ServiceOptimisticLockException ople){
			throw new ControllerException("Database operation failed because data was changed by another session. You will have to re-load it and re-apply your changes.");	
		}catch (Exception e){
			throw new ControllerException(e.getMessage(),e);
		}
	}
	
	public List<Device> getDevices() throws ControllerException {
		try {
			return getInventoryService().getDevices();
		} catch (Exception e) {
			throw new ControllerException(e.getMessage(),e);
		}
	}

	public List<Facility> getFacilities() throws ControllerException {
		try {
			return getInventoryService().getFacilities();
		} catch (Exception e) {
			throw new ControllerException(e.getMessage(),e);
		}
	}

	public List<Vendor> getVendors() throws ControllerException {
		try {
			return getInventoryService().getVendors();
		} catch (Exception e) {
			throw new ControllerException(e.getMessage(),e);
		}
	}

	public List<Visn> getVisns() throws ControllerException {
		try {
			return getInventoryService().getVisns();
		} catch (Exception e) {
			throw new ControllerException(e.getMessage(),e);
		}
	}
	
	public List<ReportWeek> getReportWeeks() throws ControllerException {
		try {
			return getInventoryService().getReportWeeks();	
		} catch (Exception e) {
			throw new ControllerException(e.getMessage(),e);
		}
	}	
	
	private InventoryConversionService inventoryConversionService = null;

	public InventoryConversionService getInventoryConversionService() {
		return inventoryConversionService;
	}

	public void setInventoryConversionService(
			InventoryConversionService inventoryConversionService) {
		this.inventoryConversionService = inventoryConversionService;
	}	
	
	//move to qir controller
	/*
	private QIRConversionService qirConversionService = null;

	public QIRConversionService getQirConversionService() {
		return qirConversionService;
	}

	public void setQirConversionService(QIRConversionService qirConversionService) {
		this.qirConversionService = qirConversionService;
	}
	
	public List<QIRSearchResult> searchQIR(QIRSearchParameters qirSearchParameters)
	throws ControllerException {
		try {
			List<Object[]> data = getQirService().searchQIR(qirSearchParameters);
			
			List<QIRSearchResult> results = new ArrayList<QIRSearchResult>();
			for (Object[] objs:data){
				QIRSearchResult record = new QIRSearchResult();
				record.id = String.valueOf(objs[0]);
				record.qirType = (String)objs[1];
				record.qirStatusType = (String)objs[2];
				record.visn = (String)objs[3];
				record.facility = (String)objs[4];
				record.deviceType = (String)objs[5];
				record.vendor = (String)objs[6];			
				record.complaint = (String)objs[7];	
				record.headline = (String)objs[8];				
				record.submittedDate = (Date)objs[9];
				record.vendorResponseDueDate = (Date)objs[10];
				record.submittedByName = (String)objs[11];
				results.add(record);
			}		
			return results;
		}catch (Exception e){
			throw new ControllerException(e.getMessage(),e);
		}
	}
	
	public QIRForm getQIR(String id) throws ControllerException {
		EntityKey<QIR> entityKey = EntityKeyFactory.createEntityKey(new Long(id), QIR.class);
		try {
			QIR qir = getQirService().getQIR(entityKey);
			QIRForm qirForm = new QIRForm();
			getQirConversionService().convert(qir, qirForm);
			return qirForm;
		}catch (Exception e){
			throw new ControllerException(e.getMessage(),e);
		}
	}
	
	public void addQIR(QIRForm qirForm) throws ControllerException {
		try {
			QIR qir = new QIR();
			getQirConversionService().convert(qirForm, qir);
			getQirService().updateQIR(qir);
		}catch (Exception e){
			throw new ControllerException(e.getMessage(),e);
		}
	}
	
	public void updateQIR(QIRForm qirForm) throws ControllerException{
		try {
			EntityKey<QIR> entityKey = EntityKeyFactory.createEntityKey(new Long(qirForm.getId()), QIR.class);
			QIR qir = getQirService().getQIR(entityKey);
			if (qir != null) {
				getQirConversionService().convert(qirForm, qir);
				getQirService().updateQIR(qir);
				//Add attachments
				List<AttachmentForm>  attachments = qirForm.getAttachments();
				if (attachments == null) attachments = new ArrayList<AttachmentForm>();
				// Assume no deletions
				for (AttachmentForm attachment:attachments) {
					if (StringUtils.isEmpty(attachment.getId())) {
						QIRAttachment newAttachment = new QIRAttachment();
						newAttachment.setDate(attachment.getDate());
						newAttachment.setDocumentName(attachment.getName());
						newAttachment.setDocumentType(
							getQirConversionService().getLookup(DocumentType.class, attachment.getType()));
						newAttachment.setData(attachment.getData());
						newAttachment.setQirId(qir.getId());
						getQirService().updateQIRAttachment(newAttachment);
					}
				}
			}else {
				throw new Exception ("QIR Not found");
			}
		}catch (Exception e){
			throw new ControllerException(e.getMessage(),e);
		}
	}*/
}
