package gov.va.med.ccht.controller;

import gov.va.med.ccht.model.dmp.DMP;
import gov.va.med.ccht.model.dmp.DMPQuestion;
import gov.va.med.ccht.model.dmp.DMPStandLibCatType;
import gov.va.med.ccht.model.dmp.DMPStandLibClinicalGuidanceType;
import gov.va.med.ccht.model.dmp.DMPStandLibContentType;
import gov.va.med.ccht.model.dmp.DMPStandLibEntry;
import gov.va.med.ccht.model.dmp.DMPStandLibRsnModType;
import gov.va.med.ccht.model.dmp.DMPStatusType;
import gov.va.med.ccht.model.dmp.DMPResponseType;
import gov.va.med.ccht.model.dmp.DMPContentType;
import gov.va.med.ccht.service.common.TerminologyException;
import gov.va.med.ccht.ui.common.AbstractConversionService;
import gov.va.med.ccht.ui.model.DMPForm;
import gov.va.med.ccht.ui.model.DMPSearchForm;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.ui.conversion.ConversionServiceException;
import gov.va.med.fw.ui.model.Form;

public class DMPConversionService extends AbstractConversionService {
	@Override
	public void convert(AbstractEntity bom, Form form)
			throws ConversionServiceException {
		try {
			if (bom instanceof DMP) {
				toDMPForm((DMP)bom, (DMPForm)form);
			}
		}catch(Exception e){
			throw new ConversionServiceException(e.getMessage(),e);
		}
	}

	@Override
	public void convert(Form form, AbstractEntity bom)
			throws ConversionServiceException {
		try {
			if (bom instanceof DMP) {
				toDMP((DMPForm)form, (DMP) bom);
			}
		}catch(Exception e){
			throw new ConversionServiceException(e.getMessage(),e);
		}
	}
	public void processTermTypes(DMPForm dmpForm)throws TerminologyException{
		dmpForm.getDmp().setDmpStatusType(getLookup(DMPStatusType.class,dmpForm.getDmpStatusType()));
	}
	public void processDMPTypes(DMPForm dmpForm){
		dmpForm.setDmpStatusType(toTermType(dmpForm.getDmp().getDmpStatusType()));
	}
	public void processDmpStandLibEntryTermTypes(DMPStandLibEntry dmpStandLibEntry) throws TerminologyException{
		//dmpStandLibEntry.setClinicalGuidanceType(getLookup(DMPStandLibClinicalGuidanceType.class,dmpStandLibEntry.getClinicalGuidanceTermType()));
		dmpStandLibEntry.setSlCategoryType(getLookup(DMPStandLibCatType.class,dmpStandLibEntry.getSlCategoryTermType()));
		dmpStandLibEntry.setSlContentType(getLookup(DMPStandLibContentType.class,dmpStandLibEntry.getSlContentTermType()));
		dmpStandLibEntry.setReasonModType(getLookup(DMPStandLibRsnModType.class,dmpStandLibEntry.getReasonModTermType()));
		}
	public void processDmpStandLibEntryTypes(DMPStandLibEntry dmpStandLibEntry) {
		//dmpStandLibEntry.setClinicalGuidanceTermType(toTermType(dmpStandLibEntry.getClinicalGuidanceType()));
		dmpStandLibEntry.setSlCategoryTermType(toTermType(dmpStandLibEntry.getSlCategoryType()));
		dmpStandLibEntry.setSlContentTermType(toTermType(dmpStandLibEntry.getSlContentType()));
		dmpStandLibEntry.setReasonModTermType(toTermType(dmpStandLibEntry.getReasonModType()));
	}
	public void processQuestionResponseTermType(DMPQuestion dmpQuestion) throws TerminologyException{
		dmpQuestion.setDmpResponseType(getLookup(DMPResponseType.class,dmpQuestion.getQuestionResponseTermType()));
	}
	public void processQuestionResponse(DMPQuestion dmpQuestion){
		dmpQuestion.setQuestionResponseTermType(toTermType(dmpQuestion.getDmpResponseType()));
	}
	public void processQuestionContentTermType(DMPQuestion dmpQuestion) throws TerminologyException{
		dmpQuestion.setDmpContentType(getLookup(DMPContentType.class,dmpQuestion.getQuestionContentTermType()));
	}
	public void processQuestionContent(DMPQuestion dmpQuestion) {
		dmpQuestion.setQuestionContentTermType(toTermType(dmpQuestion.getDmpContentType()));
	}

	private void toDMP(DMPForm dmpForm, DMP dmp)throws TerminologyException{
		if(dmp.getId()!=null)
		{
		  dmp.setId(Long.parseLong(dmpForm.getId()));
		}
		dmp.setDescription(dmpForm.getDescription());
		dmp.setObjective(dmpForm.getObjective());	
		dmp.setName(dmpForm.getName());
		dmp.setDateCreated(dmpForm.getDateCreated());
		dmp.setDmpStatusType(getLookup(DMPStatusType.class,dmpForm.getDmpStatusType()));
		
		/**
		 * CCR 1056 - REMOVED TO BACK OUT CODE TO PRE-1056		 
		dmp.setTag("na");		
		dmp.setCanEdit(dmpForm.getCanEdit());
		*/
	}
	
	private void toDMPForm(DMP dmp, DMPForm dmpForm) {
		dmpForm.setId(String.valueOf(dmp.getId()));
		dmpForm.setCreatedBy(dmp.getCreatedBy().getChangeUser());
		dmpForm.setDateCreated(dmp.getDateCreated());
		//dmpForm.setDateModified(dmp.getModifiedOn());
		dmpForm.setDescription(dmp.getDescription());
		dmpForm.setModifiedBy(dmp.getModifiedBy().getChangeUser());
		dmpForm.setName(dmp.getName());
		dmpForm.setObjective(dmp.getObjective());
		dmpForm.setDmpStatusType(toTermType(dmp.getDmpStatusType()));
		
		/**
		 * CCR 1056 - REMOVED TO BACK OUT CODE TO PRE-1056		
		dmpForm.setCanEdit(dmp.getCanEdit());		
		*/
	}
	public void processDMPTypes(DMPSearchForm dmpForm){
		dmpForm.setDmpStatusType(toTermType(dmpForm.getDmp().getDmpStatusType()));
	}

}
