package gov.va.med.ccht.controller;

import gov.va.med.ccht.model.car.CensusActivityRecord;
import gov.va.med.ccht.model.car.CensusActivityReportParameters;
import gov.va.med.ccht.model.car.CensusActivityReportResult;
import gov.va.med.ccht.model.car.CensusActivitySubTotalRecord;
import gov.va.med.ccht.service.dmpreport.CensusActivityReportService;
import gov.va.med.ccht.ui.common.AbstractController;
import gov.va.med.ccht.ui.common.ControllerException;
import gov.va.med.fw.persistent.DAOException;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CensusActivityReportController  extends AbstractController 
{
	private CensusActivityReportService censusActivityReportService;


	
	public CensusActivityReportService getCensusActivityReportService() {
		return censusActivityReportService;
	}

	public void setCensusActivityReportService(
			CensusActivityReportService censusActivityReportService) {
		this.censusActivityReportService = censusActivityReportService;
	}
 	
	public  List<CensusActivityReportResult> getReport(CensusActivityReportParameters params) throws ControllerException
	{
		int reportType = params.getReportType();
		 List<CensusActivityReportResult> results = new ArrayList<CensusActivityReportResult>();
		try
		{
			switch(reportType)
			{
			case CensusActivityReportParameters.NATIONAL:
				//results = censusActivityReportService.getNationalReport(params);
				break;
				
				
			case CensusActivityReportParameters.VISN:
				censusActivityReportService.getVisnReport(params);
				break;
				
			case CensusActivityReportParameters.FACILITY:
				censusActivityReportService.getFacilityReport(params);
				break;
			}
		}
		catch(Exception e)
		{
			throw handleException(e.getMessage(), e);
		}
		return results;
	}
	
	
	/**
	 * National report when no vendor or modality has been chosen.
	 * @param params
	 * @throws ControllerException
	 */
	public List<CensusActivityRecord> getNationalReport(CensusActivityReportParameters params) throws ControllerException
	{
		try
		{
			return censusActivityReportService.getNationalReport(params);
		}
		catch (Exception e)
		{
			throw handleException(e.getMessage(), e);
		}
	}
	public List<CensusActivitySubTotalRecord> getSubTotaledNationalReport(CensusActivityReportParameters params)throws ControllerException
	{
		try
		{
			return censusActivityReportService.getSubTotaledNationalReport(params);
		}
		catch (Exception e)
		{
			throw handleException(e.getMessage(), e);
		}
	}
	
	/*
	 * National report when a vendor has been selected but no modality has been chosen.
	 * @param params
	 * @throws ControllerException
	 */
	public List<CensusActivityRecord> getNationalReportByVendor(CensusActivityReportParameters params) throws ControllerException
	{
		try
		{
			return censusActivityReportService.getNationalReportByVendor(params);
		}
		catch (Exception e)
		{
			throw handleException(e.getMessage(), e);
		}
	}

	/**
	 * National report when a vendor has not been selected but a modality has been chosen.
	 * @param params
	 * @throws ControllerException
	 */
	public List<CensusActivityRecord> getNationalReportByModality(CensusActivityReportParameters params) throws ControllerException
	{
		try
		{
			return censusActivityReportService.getNationalReportByModality(params);
		}
		catch (Exception e)
		{
			throw handleException(e.getMessage(), e);
		}
	}
	
	public List<CensusActivitySubTotalRecord> getSubTotaledNationalReportByModality(CensusActivityReportParameters params)throws ControllerException
	{
		try
		{
			return censusActivityReportService.getSubTotaledNationalReportByModality(params);
		}
		catch (Exception e)
		{
			throw handleException(e.getMessage(), e);
		}
	}
	public List<CensusActivityRecord> getNationalReportByModalityAndVendor(CensusActivityReportParameters params) throws ControllerException
	{
		try
		{
			return censusActivityReportService.getNationalReportByModalityAndVendor(params);
		}
		catch (Exception e)
		{
			throw handleException(e.getMessage(), e);
		}
	}

	public CensusActivityRecord getLastReportWeek() throws ControllerException
	{
		try
		{
			return censusActivityReportService.getLastReportWeek();
		}
		catch (Exception e)
		{
			throw handleException(e.getMessage(), e);
		}
	}
}
