/**
 * 
 */
package gov.va.med.ccht.service.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.testng.Assert;
import org.testng.annotations.Test;

import gov.va.med.fw.model.UserPrincipalImpl;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.service.ServiceException;

import gov.va.med.ccht.model.inventory.DIReportParameters;
import gov.va.med.ccht.model.inventory.ReportWeek;
import gov.va.med.ccht.model.report.ReportSetup;
import gov.va.med.ccht.model.report.ScheduledReport;
import gov.va.med.ccht.model.report.SimpleCompletedReport;
import gov.va.med.ccht.model.terminology.ReportFormat;
import gov.va.med.ccht.model.terminology.StandardReport;
import gov.va.med.ccht.service.common.TerminologyException;
import gov.va.med.ccht.service.inventory.InventoryService;
import gov.va.med.ccht.util.AbstractCCHTTest;

/**
 * @author vhaisakatikm
 * 
 */
public class TestReportService extends AbstractCCHTTest {

	private static DIReportParameters reportParameters = null;

	@Resource
	private ReportGenerationService reportGenerationService = null;
	@Resource
	private StandardReportService standardReportService = null;
	@Resource
	private InventoryService inventoryService = null;	

	private static String reportExportedType = "1"; // 1-pdf 3-xls

	@Test(groups = "functionalTest")
	public void testDIReports() throws TerminologyException, ServiceException, CloneNotSupportedException {
/*		reportGenerationService.buildReport(createReportData("DI1", reportExportedType,
				ReportFormat.SUMMARY, ReportConstants.REPORT_SUMMARY_TYPE_FACILITY));
		reportGenerationService.buildReport(createReportData("DI 1", reportExportedType,
				ReportFormat.SUMMARY, ReportConstants.REPORT_SUMMARY_TYPE_VISN));
		reportGenerationService.buildReport(createReportData("DI 1", reportExportedType,
				ReportFormat.SUMMARY, ReportConstants.REPORT_SUMMARY_TYPE_NATIONAL));
		reportGenerationService.buildReport(createReportData("DI 1", reportExportedType,
				ReportFormat.SUMMARY, ReportConstants.REPORT_SUMMARY_TYPE_FACILITY));
		reportGenerationService.buildReport(createReportData("DI 1", reportExportedType,
				ReportFormat.SUMMARY, ReportConstants.REPORT_SUMMARY_TYPE_VISN));*/
		reportGenerationService.buildReport(createReportData("DI1", reportExportedType,
				ReportFormat.SUMMARY, ReportConstants.REPORT_SUMMARY_TYPE_NATIONAL));
	}


	@Test(groups = "xfunctionalTest")
	public void testPurgeCompletedReports() throws ServiceException{
		standardReportService.purgeCompletedReports();
	}

	@Test(groups = "xfunctionalTest")
	public void testCompletedReportService() throws ServiceException{
		// test1
		CompletedReportsSearchQueryInfo searchQueryInfo = new CompletedReportsSearchQueryInfo();
		List<SimpleCompletedReport> list = standardReportService.searchCompletedReports(searchQueryInfo);
		Assert.assertNotNull(list);
		// test2
		searchQueryInfo = new CompletedReportsSearchQueryInfo();
		searchQueryInfo.setUser(new UserPrincipalImpl("ciss1"));
		list = standardReportService.searchCompletedReports(searchQueryInfo);
		Assert.assertNotNull(list);
		// test3
		searchQueryInfo = new CompletedReportsSearchQueryInfo();
		List<String> reportIds = new ArrayList<String>();
		reportIds.add("1");
		searchQueryInfo.setReportIds(reportIds);
		list = standardReportService.searchCompletedReports(searchQueryInfo);
		Assert.assertNotNull(list);
	}

	@Test(groups = "xfunctionalTest")
	public void testScheduledReportService() throws ServiceException{
		// test1
		ReportFilterSearchQueryInfo searchQueryInfo = new ReportFilterSearchQueryInfo();
		List<ScheduledReport> list = standardReportService.searchScheduledReports(searchQueryInfo);
		Assert.assertNotNull(list);
		// test2
		searchQueryInfo = new ReportFilterSearchQueryInfo();
		searchQueryInfo.setUser(new UserPrincipalImpl("ihtaadmin"));
		list = standardReportService.searchScheduledReports(searchQueryInfo);
		Assert.assertNotNull(list);
	}

	private Map<String, ReportSetup> createReportData(String reportCode, String exportedFileType,
			String reportFormat, String summaryType) throws TerminologyException, CloneNotSupportedException, ServiceException {
		return createReportData(reportCode, exportedFileType, reportFormat, summaryType, null);
	}

	private Map<String, ReportSetup> createReportData(String reportCode, String exportedFileType,
			String reportFormat, String summaryType, String vacStatus) throws TerminologyException, CloneNotSupportedException, ServiceException  {
		Map<String, ReportSetup> map = new HashMap<String, ReportSetup>();
		ReportSetup reportSetup = createReportSetup(reportCode, exportedFileType, reportFormat,
				summaryType, vacStatus);
		map.put(ReportConstants.REPORT_SETUP, reportSetup);
		return map;
	}

	private ReportSetup createReportSetup(String reportCode, String exportedFileType,
			String reportFormat, String summaryType, String vacStatus) throws TerminologyException,CloneNotSupportedException,ServiceException{
		ReportSetup reportSetup = new ReportSetup();
		reportSetup.setStandardReport(getLookup(StandardReport.class, reportCode));
		reportSetup.setFileType(getLookup(ReportExportedType.class, exportedFileType));
		reportSetup.setSetupUser("ihtaadmin");
		DIReportParameters parameters = createStandardReportParameters(reportFormat, summaryType);
		reportSetup.setReportParameters(parameters);

		return reportSetup;
	}

	/**
	 * Common report parameters create once and reuse for all test cases
	 * 
	 * @return
	 */
	private DIReportParameters createStandardReportParameters(String reportFormat,
			String summaryType)throws CloneNotSupportedException,TerminologyException,ServiceException {
		if (reportParameters == null) {
			reportParameters = new DIReportParameters();

		}
		DIReportParameters parameters = (DIReportParameters) reportParameters.clone();
		parameters.setReportFormat(getLookup(ReportFormat.class, reportFormat));
		if (ReportFormat.SUMMARY.equals(reportFormat) && summaryType != null) {
			parameters.setReportSummaryType(summaryType);
		}
		parameters.setSubTotalType("Vendor");
		List<ReportWeek> reportWeeks = inventoryService.getReportWeeks();
		reportParameters.setReportWeek(reportWeeks.get(0));
		return parameters;
	}

	public StandardReportService getStandardReportService() {
		return standardReportService;
	}

	public void setStandardReportService(StandardReportService standardReportService) {
		this.standardReportService = standardReportService;
	}

	public ReportGenerationService getReportGenerationService() {
		return reportGenerationService;
	}

	public void setreportGenerationService(ReportGenerationService reportGenerationService) {
		this.reportGenerationService = reportGenerationService;
	}
}
