/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.service.inventory;

import java.util.Calendar;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.util.Assert;
import org.testng.annotations.Test;

import gov.va.med.ccht.model.inventory.DIReportParameters;
import gov.va.med.ccht.model.inventory.ReportWeek;
import gov.va.med.ccht.model.report.ReportSetup;
import gov.va.med.ccht.util.AbstractCCHTTest;
import gov.va.med.fw.service.ServiceException;

public class TestInventoryService extends AbstractCCHTTest {

	@Resource
	private InventoryService inventoryService = null;
	
	@Test(groups = "xfunctionalTest")
	public void testReportWeeks() throws ServiceException {
		System.out.println("TestInventoryService.testReportWeeks	begin");
		Assert.notNull(inventoryService);
		List<ReportWeek> weeks = inventoryService.getReportWeeks();	
		Assert.notEmpty(weeks);
		System.out.println(weeks);
		System.out.println("TestInventoryService.testReportWeeks	end");
	}
	
	@Test(groups = "xfunctionalTest")
	public void testGenerateInventoryReports() throws ServiceException{
		System.out.println("TestInventoryService.testGenerateInventoryReports	begin");
		Assert.notNull(inventoryService);
		ReportSetup reportSetup = new ReportSetup();
		DIReportParameters reportParameters = new DIReportParameters();
		reportSetup.setReportParameters (reportParameters);
		String[] subTotalTypes = {"Vendor", "Device Model" };
		String[] reportTypes = {/*"National", */"VISN", "Facility"};

		reportParameters.setReportSummaryType("National");		
		Calendar startDate = Calendar.getInstance();
		startDate.set(2009,10,1);
		Calendar endDate = Calendar.getInstance();
		endDate.set(2009,11,1);
		ReportWeek reportWeek = new ReportWeek(startDate.getTime(), endDate.getTime());
		reportParameters.setReportWeek(reportWeek);
		for (String reportType: reportTypes) {
			reportParameters.setReportSummaryType(reportType);
			for (String subTotalType: subTotalTypes) {	
				reportParameters.setSubTotalType(subTotalType);
				System.out.println("*** Executing " + reportType + " " + subTotalType);
				List<Object[]> results = inventoryService.generateInventoryReports(reportSetup);
				if (results != null && results.size() > 0) {
					//Assert.notEmpty(results);		
					int rows = 0;
					for (Object[] objs:results) {
						String rowData = "";
						for (Object obj:objs){
							rowData += String.valueOf(obj);
						}
						System.out.println(rows + " " + rowData);
						rows ++;
						if (rows > 10) break;
					}
				}
				else {
					System.out.println("*** Empty Result Set");
				}
			}
		}
		System.out.println("TestInventoryService.testGenerateInventoryReports	end");
	}
	
}
