/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.service.common;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.testng.annotations.Test;

import gov.va.med.ccht.model.terminology.InactiveReason;
import gov.va.med.ccht.model.terminology.ReportFormat;
import gov.va.med.ccht.util.AbstractCCHTTest;

/**
 * 
 * 
 * CISS ciss_common Aug 12, 2010
 * 
 * @author vhaisakatikm
 */
public class TestTerminologyService extends AbstractCCHTTest {

	@Autowired
	private TerminologyService terminologyService = null;
	
	private static final List<Class> lookupClasses = new ArrayList<Class>();
	
	static {		
		//lookupClasses.add(InactiveReason.class);
		//lookupClasses.add(RegistrationStatus.class);
		//lookupClasses.add(UserGroup.class);
		lookupClasses.add(ReportFormat.class);
	}

	@Test(groups = "functionalTest")
	public void testTerminologyService() throws TerminologyException {
		System.out.println("TestTerminologyService.testTerminologyService	begin");
		Assert.notNull(terminologyService);
		// setTerminologyService(
		// (TerminologyService)applicationContext.getBean("terminologyService"));
		for (Class c : lookupClasses) {
			List lookups = terminologyService.findAll(c);
			Assert.notNull(lookups);
			System.out.println(" Count of " + c.getName() + " = " + lookups.size() );
		}
			
		System.out.println("TestTerminologyService.testTerminologyService	end");
	}
}
