/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.service.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import javax.annotation.Resource;

import org.springframework.util.Assert;
import org.testng.annotations.Test;

import gov.va.med.fw.model.ldap.SearchCriteria;
import gov.va.med.fw.security.Application;
import gov.va.med.fw.security.Permission;
import gov.va.med.fw.security.Role;
import gov.va.med.fw.service.ServiceException;

import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.UserRole;
import gov.va.med.ccht.util.AbstractCCHTTest;

public class TestSecurityService extends AbstractCCHTTest {

	@Resource
	private SecurityService securityService = null;
	
	@Test(groups = "xfunctionalTest")
	public void testRolesAndPermissions() throws ServiceException {
		System.out.println("TestSecurityService.testSecurityService	begin");
		Assert.notNull(securityService);
		Set<String> roleNames = securityService.getAvailableRoleNames((Application)null);
		for (String name : roleNames) {
			System.out.println("Role: " + name);
			Role role = securityService.getRole(name);
			Assert.notNull(role);
			Set<Permission> permissions = role.getPermissions();
			Assert.notNull(permissions);
			for (Permission p: permissions) {
				System.out.println("Permission Name: " + p.getName());
			}
		}	
		System.out.println("TestSecurityService.testSecurityService	end");
	}
	
	@Test(groups = "xfunctionalTest")
	public void testUser() throws ServiceException {
		System.out.println("TestSecurityService.testUser	begin");
		Assert.notNull(securityService);
		List<String> usernames = securityService.getUserIds();
		for (String name : usernames) {
			System.out.println("User Name: " + name);
			User user = securityService.getUser(name);
			Assert.notNull(user);
			System.out.println("User Full Name: " + user.getFamilyName() + ", " + user.getGivenName() + " " + user.getMiddleName());
			Set<UserRole> userRoles = user.getRoles();
			Assert.notNull(userRoles);
			for (UserRole ur: userRoles) {
				System.out.println("Role Name: " + ur.getRole().getName());
			}
		}	
		System.out.println("TestSecurityService.testUser	end");
	}
	
	@Test(groups = "xfunctionalTest")
	public void testFindAppUsers() throws ServiceException {
		System.out.println("TestSecurityService.testFindAppUser	begin");
		Assert.notNull(securityService);
		
		List<String> adminRoles = new ArrayList<String>();
		adminRoles.add("Administrator");
		SearchCriteria searchCriteria = new SearchCriteria();
		searchCriteria.setRoles(adminRoles);
		List<User> admins = securityService.findAppUsers(searchCriteria);		

		for (User user : admins) {
			System.out.println("User Name: " + user.getUsername());
		}	
		System.out.println("TestSecurityService.testUser	end");
	}
}
