/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.service.common;

import gov.va.med.ccht.model.User;
import gov.va.med.ccht.util.AbstractCCHTTest;
import gov.va.med.fw.service.ServiceException;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.util.Assert;
import org.testng.annotations.Test;

public class TestRegistrationService extends AbstractCCHTTest {

	@Resource
	private SecurityService securityService = null;
	@Resource
	private RegistrationService registrationService = null;
	
	@Test(groups = "xfunctionalTest")
	public void testEMails() throws ServiceException {
		System.out.println("TestRegistrationService.testEMails	begin");
		Assert.notNull(securityService);
		Assert.notNull(registrationService);
		User user = securityService.getUser("vhaisakatikm");
		Assert.notNull(user);
		registrationService.sendConfirmationMail(user);
		registrationService.sendWelcomeMail(user);
		registrationService.sendDeniedMail(user);
		List<User> admins = new ArrayList<User>();
		admins.add(user);
		registrationService.sendAdminMail(user, admins);		
		System.out.println("TestRegistrationService.testEMails	end");
	}
}
