package gov.va.med.fw.service.config;

import java.util.Properties;

import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import java.util.*;

public class LogPropertyPlaceholderConfig extends PropertyPlaceholderConfigurer 
{
	
	private Map<String, Object> logPropertiesMap = new HashMap<String, Object>();
	
	public LogPropertyPlaceholderConfig()
	{
		super();
	}
	
	protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException 
	{
		ConfigurableListableBeanFactory currentFactory = beanFactoryToProcess;		
				
		// process the beans in the factory using the super implementation
		while (currentFactory != null) 
		{
			super.processProperties(currentFactory, props);
			currentFactory = (ConfigurableListableBeanFactory) currentFactory
					.getParentBeanFactory();
		}
		
			for (Object key : props.keySet()) 
			{
				String keyStr = key.toString();
				String value = props.getProperty(keyStr);
				logPropertiesMap.put(keyStr, value);	
			}
		
	}
	
	public Map<String, Object> fetchProperties()
	{
		return logPropertiesMap;
	}
	
}
