package gov.va.med.ccht.util;

import java.util.List;
import java.util.TimeZone;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.transaction.BeforeTransaction;

import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.security.LoginManager;
import gov.va.med.fw.util.AbstractTestForTestNG;
import gov.va.med.fw.util.date.TimeZoneUtils;

import gov.va.med.ccht.service.common.SecurityService;
import gov.va.med.ccht.service.common.TerminologyException;
import gov.va.med.ccht.service.common.TerminologyService;

/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/

/**
 * IHTA - IHTA_common TODO: add content here
 * 
 * Jul 22, 2010
 * 
 * @author VHAISWBOHMEG
 */
@ContextConfiguration(locations = { "classpath:spring/cchtAppContext-test.xml" })
public abstract class AbstractCCHTTest extends AbstractTestForTestNG {

	@Resource
	private TerminologyService terminologyService;
	@Resource
	private LoginManager loginManager;

	@Autowired
	protected SecurityService securityService = null;

	//@Autowired
	//protected EnvironmentParamService envParamService;

	@BeforeTransaction
	public void login() {
		login("TestDriver");
	}

	protected void login(String id) {
		String timeZoneId = initServerTimeZoneId();
		log("** Server running in TimeZone: " + timeZoneId);
		TimeZone.setDefault(TimeZone.getTimeZone(timeZoneId));

		if (shouldLoginForTest()) {
			timeZoneId = initUserTimeZoneId();
			log("** User running in TimeZone: " + timeZoneId);

			loginManager.loginAnonymous(id, TimeZone.getTimeZone(timeZoneId));
		}
	}
	protected <T extends Lookup> T getLookup(Class<T> clazz, String code) throws TerminologyException {
		return terminologyService.getByCode(clazz, code);
	}

	protected <T extends Lookup> List<T> findAll(Class<T> clazz) throws TerminologyException {
		return terminologyService.findAllActive(clazz);
	}

	/** Subclasses can override this */
	protected boolean shouldLoginForTest() {
		return true;
	}

	protected String initUserTimeZoneId() {
		return TimeZoneUtils.getTimeZone().getID();
	}

	protected TimeZone getUserTimeZone() {
		return TimeZone.getDefault();
	}

	protected String initServerTimeZoneId() {
		return TimeZoneUtils.getTimeZone().getID();
	}

	protected void log(Object obj) {
		String str = obj != null ? obj.toString() : null;
		System.out.println(str);
		logger.info(str);
	}
}
