/**
 * 
 */
package gov.va.med.ccht.service.report.impl;

import java.util.Date;
import java.util.Map;

import org.apache.commons.lang.Validate;

import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;

import gov.va.med.ccht.model.report.ReportSetup;
import gov.va.med.ccht.model.report.ScheduledReport;
import gov.va.med.ccht.service.report.ReportConstants;
import gov.va.med.ccht.service.report.ReportGenerationService;
import gov.va.med.ccht.service.report.StandardReportService;

/**
 * @author vhaisakatikm
 * 
 */
public class ReportGenerationServiceImpl extends AbstractComponent implements
		ReportGenerationService, ReportConstants {

	private StandardReportService standardReportService = null;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.IHTA.service.report.ReportGenerationService#buildReport(java
	 * .util.Map)
	 */
	public void buildReport(Map<String,?> reportData) throws ServiceException {
		try {
			ReportSetup setup = null;

			String reportSetupId = (String) reportData.get(REPORT_SETUP_ID);

			// If the id is available get the report setup object from the
			// database
			if (StringUtils.isNotEmpty(reportSetupId)) {
				ScheduledReport scheduledReport  = standardReportService.getScheduledReport(
						EntityKeyFactory.createEntityKey(new Long(reportSetupId), ScheduledReport.class));					
						
				// update report generation date for the scheduled report
				scheduledReport.setReportGenerateDate(new Date());
				try {
					standardReportService.saveScheduledReport(scheduledReport, false);
					//convert and create report setup
					setup = new ReportSetup();
					setup.setReportParameters(scheduledReport.getReportParameters());
					setup.setReportParametersText(scheduledReport.getReportParameterText());
					setup.setReportSchedule(scheduledReport.getReportSchedule());
					setup.setReportScheduleText(scheduledReport.getReportScheduleText());					
					setup.setSetupUser(scheduledReport.getUserName());
					setup.setEmailAddress(scheduledReport.getEmail());
					setup.setFileType(scheduledReport.getFileType());
					setup.setStandardReport(scheduledReport.getStandardReport());
				} catch (Exception dae) {
					logger.error("Could not update run date on scheduled reports id:"
							+ reportSetupId);
					throw new ServiceException("Could not update run date on scheduled reports id:"
							+ reportSetupId, dae);
				}
			} else {
				setup = (ReportSetup) reportData.get(REPORT_SETUP);
			}
			//Save the criteria if the export type is DATA  
			if (setup.getFileType() == null || setup.getFileType().getCode().equals("9")) {
				standardReportService.saveReportCriteria(setup);
			}else {					
				standardReportService.buildReport(setup);
			}
		} catch (Exception e) {
			logger.error("Could not generate the report " + e.getMessage());
			throw new ServiceException("Could not generate the report ", e);
		}
	}

	public StandardReportService getStandardReportService() {
		return standardReportService;
	}

	public void setStandardReportService(StandardReportService standardReportService) {
		this.standardReportService = standardReportService;
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		// TODO Auto-generated method stub
		super.afterPropertiesSet();
		Validate.notNull(this.standardReportService, "A standard report service must be configured");
	}

}
