/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.ccht.service.report;

import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.SimpleReportNameResolver;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.util.StringUtils;

import gov.va.med.ccht.model.inventory.DIReportParameters;
import gov.va.med.ccht.model.report.ReportParameters;
import gov.va.med.ccht.model.report.ReportSetup;

/**
 * 
 * A ReportNameResolver that appends the report format (e.g. "detailed" or
 * "summary") to the report name. Before: "ID4Report", After:
 * "ID4Report.detailed"
 * <p>
 * Project: Common<br>
 * Created on: 4:19:11 PM
 * 
 * @author VHAISALEV
 */
public class StandardReportNameResolver extends SimpleReportNameResolver {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 2619282070914344190L;

	/**
	 * A default constructor
	 */
	public StandardReportNameResolver() {
		super();
	}

	/**
	 * @see gov.va.med.fw.report.SimpleReportNameResolver#getReportName(gov.va.med.fw.report.ReportConfiguration)
	 */
	public String getReportName(ReportConfiguration config) {
		QueryCriteria criteria = config.getQueryCriteria();
		StandardReportCriteria reportCriteria = criteria instanceof StandardReportCriteria ? (StandardReportCriteria) criteria
				: null;

		if (reportCriteria != null) {
			ReportSetup setup = reportCriteria.getReportSetup();
			ReportParameters parameterSet = setup != null ? setup.getReportParameters() : null;

			String reportFormat = getLookupName(parameterSet != null ? parameterSet
					.getReportFormat() : null);
			StringBuilder name = new StringBuilder();
			name.append(config.getReportName());
			appendToName(name, reportFormat);

			DIReportParameters diReportParameters = (DIReportParameters) parameterSet;
			String reportSummaryType = diReportParameters.getReportSummaryType();
			if (reportSummaryType == null || StringUtils.isEmpty(reportSummaryType)
					|| "null".equals(reportSummaryType)) {
				// Do not append any suffix to the name
			} else {
				if (StringUtils.equals(reportSummaryType,
						ReportConstants.REPORT_SUMMARY_TYPE_FACILITY)) {
					appendToName(name, "facility");
				} else if (StringUtils.equals(reportSummaryType,
						ReportConstants.REPORT_SUMMARY_TYPE_VISN)) {
					appendToName(name, "visn");
				} else if (StringUtils.equals(reportSummaryType,
						ReportConstants.REPORT_SUMMARY_TYPE_NATIONAL)) {
					appendToName(name, "national");
				}
			}
			//DI
			String subTotalType = diReportParameters.getSubTotalType();
			if (subTotalType == null || StringUtils.isEmpty(subTotalType)
					|| "null".equals(subTotalType)) {
				// Do not append any suffix to the name
			} else {
				if (StringUtils.equals(subTotalType,
						ReportConstants.REPORT_SUB_TOTAL_TYPE_VENDOR)) {
					appendToName(name, "vendor");
				} else if (StringUtils.equals(subTotalType,
						ReportConstants.REPORT_SUB_TOTAL_TYPE_DEVICE)) {
					appendToName(name, "device");
				} 
			}			
			return name.toString();
		}
		return super.getReportName(config);
	}

	protected void appendToName(StringBuilder name, String desc) {
		if (desc != null) {
			name.append(".");
			name.append(StringUtils.deleteWhitespace(desc));
		}
	}

	protected String getLookupName(Lookup lookup) {
		return lookup != null ? lookup.getName() : null;
	}
}
