/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.ccht.service.report;

// Framework classes
import gov.va.med.fw.report.ConfigurableReportBuilder;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportException;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportData;

import gov.va.med.ccht.model.report.ReportSetup;

// ESR classes

/**
 * Allows concrete report builder implementations to be configured through
 * spring context file
 * 
 * Project: Framework</br> Created on: 4:59:46 PM </br>
 * 
 * @author vhaisakullav
 */
public class StandardReportBuilder extends ConfigurableReportBuilder {

	private static final long serialVersionUID = -5393606047148762963L;

	/**
	 * @see gov.va.med.fw.report.ReportBuilder#buildReport(gov.va.med.fw.report.ReportConfiguration)
	 */
	public void buildReport(ReportConfiguration configuration) throws ReportException {
		super.buildReport(setReportSetupCopy(configuration));
	}

	/**
	 * @see gov.va.med.fw.report.ReportBuilder#buildReport(gov.va.med.fw.report.ReportConfiguration,
	 *      gov.va.med.fw.report.data.ReportData)
	 */
	public void buildReport(ReportConfiguration configuration, ReportData data)
			throws ReportException {
		super.buildReport(setReportSetupCopy(configuration), data);
	}

	/**
	 * A default constructor
	 */
	public StandardReportBuilder() {
		super();
	}

	/**
	 * @see gov.va.med.fw.service.AbstractComponent#afterPropertiesSet()
	 */
	public void afterPropertiesSet() throws Exception {
		super.afterPropertiesSet();
	}

	/**
	 * 
	 * @param configuration
	 * @throws ReportException
	 */
	protected ReportConfiguration setReportSetupCopy(ReportConfiguration configuration)
			throws ReportException {
		QueryCriteria criteria = configuration.getQueryCriteria();
		StandardReportCriteria reportCriteria = criteria instanceof StandardReportCriteria ? (StandardReportCriteria) criteria
				: null;
		ReportSetup reportSetup = reportCriteria != null ? reportCriteria.getReportSetup() : null;
		ReportSetup reportSetupCopy = getReportSetupCopy(reportSetup);
		reportCriteria.setReportSetup(reportSetupCopy);
		return configuration;
	}

	/**
	 * This method returns copy of getReportSetup.
	 * 
	 * @param config
	 * @return
	 * @throws ReportException
	 */
	protected ReportSetup getReportSetupCopy(ReportSetup reportSetup) throws ReportException {
		ReportSetup newReportSetup = null;
		if (reportSetup != null) {
			newReportSetup = new ReportSetup();
		}
		return newReportSetup;
	}

}