/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.service.report;

import java.util.List;
import java.util.Map;

import javax.servlet.ServletContext;

import org.springframework.beans.factory.InitializingBean;

/**
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class ReportParameterConfig implements ReportConstants, InitializingBean {

	private ServletContext servletContext;

	private Map parameterMap;
	private List reportIds;
	private Map displayParams;

	public Map getParameters(String reportId) {
		return (Map) parameterMap.get(reportId);
	}

	public Map getParameterMap() {
		return parameterMap;
	}

	public Map getDisplayParams() {
		return displayParams;
	}

	public void setParameterMap(Map parameterMap) {
		this.parameterMap = parameterMap;
	}

	public Map getDisplayParams(String reportId) {
		return (Map) displayParams.get(reportId);
	}

	public List getReportIds() {
		return reportIds;
	}

	public void setDisplayParams(Map displayParams) {
		this.displayParams = displayParams;
	}

	public void setReportIds(List reportIds) {
		this.reportIds = reportIds;
	}

	public ServletContext getServletContext() {
		return servletContext;
	}

	public void setServletContext(ServletContext servletContext) {
		this.servletContext = servletContext;
	}

	public void afterPropertiesSet() throws Exception {
		if (this.getParameterMap() == null) {
			throw new Exception("Report parameter map is not configured.");
		}
	}
}
