/*******************************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ******************************************************************************/

/*
 * Created on Feb 23, 2010
 */
package gov.va.med.ccht.service.report;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

// EDB Classes

/**
 * Completed reports filter dropdown.
 * 
 * @author Venky Kullampalle
 * @version 1.0
 */
public class ReportFilter implements Serializable {

	private static final long serialVersionUID = -1732131484755403593L;

	/**
	 * List of Standard Reports
	 */
	private List standardReports;

	/**
	 * List of ReportExportTypes
	 */
	private List reportFileTypes;

	/**
	 * Count of Active reports in completed reports.
	 */
	private int activeReportsCount;

	/**
	 * Count of Inactive reports in completed reports.
	 */
	private int inactiveReportsCount;

	public int getActiveReportsCount() {
		return activeReportsCount;
	}

	public void setActiveReportsCount(int activeReportsCount) {
		this.activeReportsCount = activeReportsCount;
	}

	public int getInactiveReportsCount() {
		return inactiveReportsCount;
	}

	public void setInactiveReportsCount(int inactiveReportsCount) {
		this.inactiveReportsCount = inactiveReportsCount;
	}

	public List getReportFileTypes() {
		return reportFileTypes;
	}

	public void setReportFileTypes(List reportFileTypes) {
		this.reportFileTypes = reportFileTypes;
	}

	public List getStandardReports() {
		return standardReports;
	}

	public void setStandardReports(List standardReports) {
		this.standardReports = standardReports;
	}

	/**
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		builder.append("standardReports", this.standardReports).append("reportFileTypes",
				this.reportFileTypes).append("activeReportsCount", this.activeReportsCount).append(
				"inactiveReportsCount", this.inactiveReportsCount);
	}
}
