package gov.va.med.ccht.service.qir;

import gov.va.med.ccht.model.qir.QIR;
import gov.va.med.ccht.model.qir.QIRAttachment;
import gov.va.med.ccht.model.qir.QIRSearchParameters;
import gov.va.med.ccht.model.qir.QIRSimpleAttachment;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.ServiceException;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface QIRService {
	public List<Object[]> searchQIR(QIRSearchParameters qirSearchParameters) throws ServiceException;
	public QIR getQIR(EntityKey<QIR> entityKey) throws ServiceException;
	public void updateQIR(QIR qir) throws ServiceException;
	public void updateQIR(QIR qir,boolean updatedDueDate) throws ServiceException;
	public void updateQIRAttachment(QIRAttachment qirAttachment) throws ServiceException;
	public void deleteQIRAttachment(QIRSimpleAttachment qirAttachment) throws ServiceException;
	public QIRAttachment getQIRAttachment(EntityKey<QIRAttachment> entityKey) throws ServiceException;
	public Integer generateVendorResponseDueNotifications() throws ServiceException; 
	public void sendVendorResponseDueEMail(Map<String,?> qirData) throws ServiceException;	
	public QIR saveQIR(QIR qir) throws ServiceException;
	public Date getDueDateFromHistory(String qirId) throws ServiceException;
}
