package gov.va.med.ccht.service.inventory;

import gov.va.med.ccht.model.inventory.Device;
import gov.va.med.ccht.model.inventory.DeviceDetail;
import gov.va.med.ccht.model.inventory.DeviceRequirement;
import gov.va.med.ccht.model.inventory.DeviceSearchParameters;
import gov.va.med.ccht.model.inventory.DeviceType;
import gov.va.med.ccht.model.inventory.Facility;
import gov.va.med.ccht.model.inventory.ReportWeek;
import gov.va.med.ccht.model.inventory.SimpleFacility;
import gov.va.med.ccht.model.inventory.SimpleVisn;
import gov.va.med.ccht.model.inventory.Vendor;
import gov.va.med.ccht.model.inventory.Visn;
import gov.va.med.ccht.model.report.ReportSetup;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.ui.model.TermType;

import java.util.List;

public interface InventoryService {
	public List<Device> getDevices() throws ServiceException;
	public List<Vendor> getVendors() throws ServiceException;
	public List<Facility> getFacilities() throws ServiceException;
	public List<Facility> getFacilities(String visnName) throws ServiceException;
	public List<Visn> getVisns() throws ServiceException;
	
	public Device getDevice(String name) throws ServiceException;
	public DeviceType getDeviceType(String code) throws ServiceException;
	
	public Vendor getVendor(String name) throws ServiceException;
	public Facility getFacility(String stationNumber) throws ServiceException;
	public Visn getVisn(String name) throws ServiceException;
	public SimpleVisn getSimpleVisn(String name) throws ServiceException;
	public List<SimpleVisn> getSimpleVisns() throws ServiceException;
	public SimpleFacility getSimpleFacility(String stationNumber) throws ServiceException;
	public List<SimpleFacility> getSimpleFacilities() throws ServiceException;
	public List<SimpleFacility> getSimpleFacilities(SimpleVisn visn) throws ServiceException;
	public List<ReportWeek> getReportWeeks() throws ServiceException;
	
	//Reports
	public List<Object[]> generateInventoryReports(ReportSetup reportSetup) throws ServiceException;
	public List<Object[]> searchDevice(DeviceSearchParameters deviceSearchParameters) throws ServiceException;
	public List<Object[]> generateVCCurrentReport(DeviceSearchParameters deviceSearchParameters) throws ServiceException;
	public List<Object[]> generateVCHistoryReport(DeviceSearchParameters deviceSearchParameters) throws ServiceException;
	public List<Object[]> generateVCReportCharts(DeviceSearchParameters deviceSearchParameters) throws ServiceException;
	public Integer generateWeeklyVendorComplianceReport() throws ServiceException;
	
	
	// HT-Reports
	public List<TermType> getModalityType(int type) throws ServiceException;
	
	//Device Detail
	public DeviceDetail getDeviceDetail(EntityKey<DeviceDetail> entityKey) throws ServiceException;
	public DeviceDetail getDeviceDetail(DeviceSearchParameters deviceSearchParameters) throws ServiceException;
	public void updateDeviceDetail(DeviceDetail deviceDetail) throws ServiceException;
	
	//Device Requirement/Shortage
	public DeviceRequirement getDeviceRequirement(EntityKey<DeviceRequirement> entityKey) throws ServiceException;
	public List<DeviceRequirement> getDeviceRequirements(SimpleFacility simpleFacility) throws ServiceException;
	public List<DeviceRequirement> updateDeviceRequirements(List<DeviceRequirement> DeviceRequirements) throws ServiceException;
	
}
