package gov.va.med.ccht.service.dmpreport.impl;


import gov.va.med.ccht.model.dmp.PatientSatSurveyReportParameters;
import gov.va.med.ccht.model.dmpreport.PSSQuestionManager;
import gov.va.med.ccht.model.dmpreport.VendorSubmissionReportEntry;
import gov.va.med.ccht.persistent.PSSReportsDAO;
import gov.va.med.ccht.service.common.impl.AbstractBusinessService;
import gov.va.med.ccht.service.dmpreport.VendorSubmissionReportService;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;

import java.util.List;


public class VendorSubmissionReportServiceImpl extends AbstractBusinessService
		implements VendorSubmissionReportService 
{

	private PSSReportsDAO pssReportsDAO;
	
	public PSSReportsDAO getPssReportsDAO() 
	{
		return pssReportsDAO;
	}
	public void setPssReportsDAO(PSSReportsDAO pssReportsDAO) 
	{
		this.pssReportsDAO = pssReportsDAO;
	}
	
	
	@Override
	public List<VendorSubmissionReportEntry> findVendorSubmissionReport(
			PatientSatSurveyReportParameters reportParams) throws ServiceException {
		
		try 
		{
			return pssReportsDAO.getVendorSubmissionReport(reportParams);
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}

	}
	
	@Override
	public PSSQuestionManager getQuestionsForReportVersion(Integer version) throws ServiceException
	{
		try 
		{
			return pssReportsDAO.getQuestionsForReportVersion(version);
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}
	}

}
