package gov.va.med.ccht.service.dmpreport.impl;


import gov.va.med.ccht.model.dmp.PatientSatSurveyReportParameters;
import gov.va.med.ccht.model.dmpreport.PSSQuestionManager;
import gov.va.med.ccht.model.dmpreport.VRTwelveReportResults;
import gov.va.med.ccht.persistent.PSSReportsDAO;
import gov.va.med.ccht.service.common.impl.AbstractBusinessService;
import gov.va.med.ccht.service.dmpreport.VRTwelveReportService;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;

import java.util.List;


public class VRTwelveReportServiceImpl extends AbstractBusinessService
		implements VRTwelveReportService 
{
	private PSSReportsDAO pssReportsDAO;
	
	public PSSReportsDAO getPssReportsDAO() 
	{
		return pssReportsDAO;
	}
	public void setPssReportsDAO(PSSReportsDAO pssReportsDAO) 
	{
		this.pssReportsDAO = pssReportsDAO;
	}
	
	@Override
	public List<VRTwelveReportResults> findVRTwelveReport(PatientSatSurveyReportParameters reportParams)
			throws ServiceException {
		
		try 
		{
			return pssReportsDAO.getVRTwelveReport(reportParams);			
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}
		
	}
	
	@Override
	public PSSQuestionManager getQuestionsForReportVersion(Integer version) throws ServiceException
	{
		try 
		{
			return pssReportsDAO.getQuestionsForReportVersion(version);
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}
	}
}
