package gov.va.med.ccht.service.dmpreport.impl;


import gov.va.med.ccht.model.dmp.PatientSatSurveyReportParameters;
import gov.va.med.ccht.model.dmpreport.PSSQuestionManager;
import gov.va.med.ccht.model.dmpreport.SurveyDistributionSearchResult;
import gov.va.med.ccht.persistent.SurveyDistributionReportDAO;
import gov.va.med.ccht.service.common.impl.AbstractBusinessService;
import gov.va.med.ccht.service.dmpreport.SurveyDistributionReportService;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;


public class SurveyDistributionReportServiceImpl extends
		AbstractBusinessService implements SurveyDistributionReportService 
{

	private SurveyDistributionReportDAO surveyDistributionReportDAO;
	
	public SurveyDistributionReportDAO getSurveyDistributionReportDAO() 
	{
		return surveyDistributionReportDAO;
	}
	public void setSurveyDistributionReportDAO(SurveyDistributionReportDAO surveyDistributionReportDAO) 
	{
		this.surveyDistributionReportDAO = surveyDistributionReportDAO;
	}
	
	@Override
	public SurveyDistributionSearchResult  findSurveyDistributionReport(
			PatientSatSurveyReportParameters reportParams) throws ServiceException {
		
		try 
		{
			return surveyDistributionReportDAO.getSurveyDistributionReport(reportParams);
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}

	}

	@Override
	public PSSQuestionManager getQuestionsForReportVersion(Integer version) throws ServiceException
	{
		try 
		{
			return surveyDistributionReportDAO.getQuestionsForReportVersion(version);
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}
	}

}
