package gov.va.med.ccht.service.dmpreport.impl;


import gov.va.med.ccht.model.dmp.PatientSatSurveyReportParameters;
import gov.va.med.ccht.model.dmpreport.PSSQuestionManager;
import gov.va.med.ccht.model.dmpreport.SatisfactionSurveyQuestionResult;
import gov.va.med.ccht.persistent.SatisfactionSurveyReportDAO;
import gov.va.med.ccht.service.common.impl.AbstractBusinessService;
import gov.va.med.ccht.service.dmpreport.SatisfactionSurveyResultService;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;

import java.util.List;

public class SatisfactionSurveyResultServiceImpl extends AbstractBusinessService implements
		SatisfactionSurveyResultService 
{
	
	//private PSSReportsDAO pssReportsDAO;
	private SatisfactionSurveyReportDAO satisfactionSurveyReportDAO;
	
	
	public SatisfactionSurveyReportDAO getSatisfactionSurveyReportDAO() 
	{
		return satisfactionSurveyReportDAO;
	}
	public void setSatisfactionSurveyReportDAO(SatisfactionSurveyReportDAO satisfactionSurveyReportDAO) 
	{
		this.satisfactionSurveyReportDAO = satisfactionSurveyReportDAO;
	}
	/*
	public PSSReportsDAO getPssReportsDAO() 
	{
		return pssReportsDAO;
	}
	public void setPssReportsDAO(PSSReportsDAO pssReportsDAO) 
	{
		this.pssReportsDAO = pssReportsDAO;
	}
	*/
	
	@Override
	public List<SatisfactionSurveyQuestionResult>  findSatisfactionSurveyResultReport(
			PatientSatSurveyReportParameters reportParams) throws ServiceException {
		
		try 
		{
			return satisfactionSurveyReportDAO.getSatisfactionSurveyReport(reportParams);
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}

	}
	
	@Override
	public PSSQuestionManager getQuestionsForReportVersion(Integer version) throws ServiceException
	{
		try 
		{
			return satisfactionSurveyReportDAO.getQuestionsForReportVersion(version);
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}
	}

	
}
